/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.screen.Panel;
import org.moddingx.libx.util.lazy.CachedValue;

public class ColorPicker
extends Panel {
    public static final int WIDTH = 200;
    public static final int HEIGHT = 100;
    private static final int HUE_VERTICES = 40;
    private static final int HSB_VERTICES = 20;
    private int red;
    private int green;
    private int blue;
    private float hue;
    private float saturation;
    private float brightness;
    private final CachedValue<TextColor> colorValue = new CachedValue<TextColor>(() -> TextColor.fromRgb((int)((this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF)));
    private final List<VertexInfo> huePanel = ColorPicker.createHuePanel(105, 0, 110, 100);
    private final CachedValue<List<VertexInfo>> hsbMatrix = new CachedValue<List>(() -> ColorPicker.createHsbMatrix(this.hue, 0, 0, 100, 100));
    private final ValueSlider redSlider = this.addRenderableWidget(new ValueSlider(115, 0, 85, 20, "libx.gui.color_picker.red", () -> this.red, red -> {
        this.red = red;
        this.updateHSB();
    }));
    private final ValueSlider greenSlider = this.addRenderableWidget(new ValueSlider(115, 23, 85, 20, "libx.gui.color_picker.green", () -> this.green, green -> {
        this.green = green;
        this.updateHSB();
    }));
    private final ValueSlider blueSlider = this.addRenderableWidget(new ValueSlider(115, 46, 85, 20, "libx.gui.color_picker.blue", () -> this.blue, blue -> {
        this.blue = blue;
        this.updateHSB();
    }));
    @Nullable
    private Consumer<TextColor> responder;
    private TextColor lastDelivered = null;
    private boolean enabled;

    public ColorPicker(int x, int y) {
        this(x, y, null);
    }

    public ColorPicker(int x, int y, @Nullable ColorPicker old) {
        super(x, y, 200, 100);
        if (old != null) {
            this.setColor(old.getColor());
        } else {
            this.update();
        }
        this.enabled = true;
    }

    public TextColor getColor() {
        return this.colorValue.get();
    }

    public void setColor(TextColor color) {
        int rgb = 0xFFFFFF & color.getValue();
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.updateHSB();
    }

    public void setResponder(@Nullable Consumer<TextColor> responder) {
        this.responder = responder;
        this.lastDelivered = null;
    }

    private void updateRGB() {
        int rgb = 0xFFFFFF & Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
        this.red = rgb >> 16 & 0xFF;
        this.green = rgb >> 8 & 0xFF;
        this.blue = rgb & 0xFF;
        this.update();
    }

    private void updateHSB() {
        float[] values = Color.RGBtoHSB(this.red, this.green, this.blue, null);
        this.hue = values[0];
        this.saturation = values[1];
        this.brightness = values[2];
        this.update();
    }

    private void update() {
        this.colorValue.invalidate();
        this.hsbMatrix.invalidate();
        this.redSlider.update();
        this.greenSlider.update();
        this.blueSlider.update();
        if (this.responder != null && (this.lastDelivered == null || this.lastDelivered.getValue() != this.colorValue.get().getValue())) {
            this.responder.accept(this.colorValue.get());
            this.lastDelivered = this.colorValue.get();
        }
    }

    @Override
    public void renderWidgetContent(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int colorValue;
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.getX(), (float)this.getY(), 0.0f);
        Matrix4f matrix = graphics.pose().last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RenderHelper.TEXTURE_WHITE);
        BufferBuilder vertex = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        if (this.enabled) {
            this.hsbMatrix.get().forEach(v -> v.add((VertexConsumer)vertex, matrix));
        } else {
            this.hsbMatrix.get().forEach(v -> v.addGrayscale((VertexConsumer)vertex, matrix));
        }
        BufferUploader.drawWithShader((MeshData)vertex.buildOrThrow());
        RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RenderHelper.TEXTURE_WHITE);
        vertex = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        if (this.enabled) {
            this.huePanel.forEach(v -> v.add((VertexConsumer)vertex, matrix));
        } else {
            this.huePanel.forEach(v -> v.addGrayscale((VertexConsumer)vertex, matrix));
        }
        BufferUploader.drawWithShader((MeshData)vertex.buildOrThrow());
        int displayColor = colorValue = (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
        if (!this.enabled) {
            int value = Math.round((float)(this.red + this.green + this.blue) / 3.0f) & 0xFF;
            displayColor = value << 16 | value << 8 | value;
        }
        int highlightColor = (double)this.brightness > 0.5 ? -16777216 : -1;
        RenderHelper.rgb(highlightColor);
        graphics.blit(RenderHelper.TEXTURE_WHITE, 115, 69, 20, 0.0f, 0.0f, 85, 31, 256, 256);
        RenderHelper.rgb(displayColor);
        graphics.blit(RenderHelper.TEXTURE_WHITE, 116, 70, 40, 0.0f, 0.0f, 83, 29, 256, 256);
        String colorText = String.format("#%06X", colorValue);
        RenderHelper.resetColor();
        graphics.pose().translate(0.0f, 0.0f, 60.0f);
        graphics.drawString(Minecraft.getInstance().font, colorText, 157 - Minecraft.getInstance().font.width(colorText) / 2, 80, highlightColor, false);
        graphics.pose().popPose();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.updateColorValue(mouseX, mouseY, mouseX, mouseY);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.updateColorValue(mouseX, mouseY, mouseX - dragX, mouseY - dragY);
    }

    private boolean updateColorValue(double mouseX, double mouseY, double boundsX, double boundsY) {
        if (!this.enabled) {
            return false;
        }
        mouseX -= (double)this.getX();
        mouseY -= (double)this.getY();
        boundsX -= (double)this.getX();
        boundsY -= (double)this.getY();
        if (boundsX >= 0.0 && boundsX <= 100.0 && boundsY >= 0.0 && boundsY <= 100.0) {
            this.saturation = (float)(Mth.clamp((double)mouseX, (double)0.0, (double)100.0) / 100.0);
            this.brightness = (float)(1.0 - Mth.clamp((double)mouseY, (double)0.0, (double)100.0) / 100.0);
            this.updateRGB();
            this.setFocused(null);
            return true;
        }
        if (boundsX >= 105.0 && boundsX <= 110.0 && boundsY >= 0.0 && boundsY <= 100.0) {
            this.hue = (float)(Mth.clamp((double)mouseY, (double)0.0, (double)100.0) / 100.0);
            this.updateRGB();
            this.setFocused(null);
            return true;
        }
        return false;
    }

    @Override
    public void enabled(boolean enabled) {
        super.enabled(enabled);
        this.enabled = enabled;
    }

    private static List<VertexInfo> createHsbMatrix(float hue, int x1, int y1, int x2, int y2) {
        LinkedList<List<ColorValue>> colors = new LinkedList<List<ColorValue>>();
        for (int y = 0; y < 20; ++y) {
            float brightness = 1.0f - (float)y / 20.0f;
            LinkedList<ColorValue> row = new LinkedList<ColorValue>();
            for (int x = 0; x < 20; ++x) {
                float saturation = (float)x / 20.0f;
                row.add(ColorValue.create(Color.HSBtoRGB(hue, saturation, brightness)));
            }
            colors.add(row);
        }
        return ColorPicker.createColorMatrix(x1, y1, x2, y2, colors);
    }

    private static List<VertexInfo> createHuePanel(int x1, int y1, int x2, int y2) {
        LinkedList<List<ColorValue>> colors = new LinkedList<List<ColorValue>>();
        for (int x = 0; x < 40; ++x) {
            float hue = (float)x / 40.0f;
            ColorValue color = ColorValue.create(Color.HSBtoRGB(hue, 1.0f, 1.0f));
            colors.add(List.of(color, color));
        }
        return ColorPicker.createColorMatrix(x1, y1, x2, y2, colors);
    }

    private static List<VertexInfo> createColorMatrix(int x1, int y1, int x2, int y2, List<List<ColorValue>> list) {
        ImmutableList.Builder vertices = ImmutableList.builder();
        for (int i = 0; i < list.size() - 1; ++i) {
            float v1 = (float)i / (float)(list.size() - 1);
            float v2 = (float)(i + 1) / (float)(list.size() - 1);
            for (int j = 0; j < list.get(i).size() - 1; ++j) {
                float u1 = (float)j / (float)(list.get(i).size() - 1);
                float u2 = (float)(j + 1) / (float)(list.get(i).size() - 1);
                float cx1 = Mth.lerp((float)u1, (float)x1, (float)x2);
                float cx2 = Mth.lerp((float)u2, (float)x1, (float)x2);
                float cy1 = Mth.lerp((float)v1, (float)y1, (float)y2);
                float cy2 = Mth.lerp((float)v2, (float)y1, (float)y2);
                vertices.add((Object)new VertexInfo(cx1, cy1, u1, v1, list.get(i).get(j)));
                vertices.add((Object)new VertexInfo(cx1, cy2, u1, v2, list.get(i + 1).get(j)));
                vertices.add((Object)new VertexInfo(cx2, cy2, u2, v2, list.get(i + 1).get(j + 1)));
                vertices.add((Object)new VertexInfo(cx2, cy1, u2, v1, list.get(i).get(j + 1)));
            }
        }
        return vertices.build();
    }

    private static class ValueSlider
    extends AbstractSliderButton {
        private final String translationKey;
        private final Supplier<Integer> getter;
        private final Consumer<Integer> setter;

        public ValueSlider(int x, int y, int width, int height, String translationKey, Supplier<Integer> getter, Consumer<Integer> setter) {
            super(x, y, width, height, (Component)Component.empty(), (double)Mth.clamp((int)getter.get(), (int)0, (int)255) / 255.0);
            this.translationKey = translationKey;
            this.getter = getter;
            this.setter = setter;
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.translatable((String)this.translationKey, (Object[])new Object[]{this.getter.get()}));
        }

        protected void applyValue() {
            this.setter.accept(Mth.clamp((int)((int)Math.round(this.value * 255.0)), (int)0, (int)255));
        }

        public void update() {
            this.value = (double)Mth.clamp((int)this.getter.get(), (int)0, (int)255) / 255.0;
            this.updateMessage();
        }
    }

    private record ColorValue(int red, int green, int blue) {
        public static ColorValue create(int value) {
            int rgb = 0xFFFFFF & value;
            return new ColorValue(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
    }

    private record VertexInfo(float x, float y, float u, float v, ColorValue color) {
        public void add(VertexConsumer vertex, Matrix4f matrix) {
            vertex.addVertex(matrix, this.x, this.y, 20.0f).setColor(this.color.red, this.color.green, this.color.blue, 255).setUv(this.u, this.v).setLight(0xF000F0);
        }

        public void addGrayscale(VertexConsumer vertex, Matrix4f matrix) {
            int value = Math.round((float)(this.color.red + this.color.green + this.color.blue) / 3.0f);
            vertex.addVertex(matrix, this.x, this.y, 20.0f).setColor(value, value, value, 255).setUv(this.u, this.v).setLight(0xF000F0);
        }
    }
}

