/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.moddingx.libx.sandbox.SandBox;

public class PoolExtension {
    public static final Codec<PoolExtension> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("pool").forGetter(p -> p.pool.location()), (App)Codec.BOOL.optionalFieldOf("required", (Object)false).forGetter(p -> p.required), (App)Codec.mapPair((MapCodec)StructurePoolElement.CODEC.fieldOf("element"), (MapCodec)Codec.intRange((int)1, (int)150).fieldOf("weight")).codec().listOf().fieldOf("elements").forGetter(p -> p.elements)).apply((Applicative)instance, PoolExtension::new));
    public static final Codec<Holder<PoolExtension>> CODEC = RegistryFileCodec.create(SandBox.TEMPLATE_POOL_EXTENSION, DIRECT_CODEC);
    private final ResourceKey<StructureTemplatePool> pool;
    private final boolean required;
    private final List<Pair<StructurePoolElement, Integer>> elements;

    private PoolExtension(ResourceLocation poolId, boolean required, List<Pair<StructurePoolElement, Integer>> elements) {
        this((ResourceKey<StructureTemplatePool>)ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)poolId), required, elements);
    }

    public PoolExtension(ResourceKey<StructureTemplatePool> pool, List<Pair<StructurePoolElement, Integer>> elements) {
        this(pool, false, elements);
    }

    public PoolExtension(ResourceKey<StructureTemplatePool> pool, boolean required, List<Pair<StructurePoolElement, Integer>> elements) {
        this.pool = pool;
        this.required = required;
        this.elements = List.copyOf(elements);
    }

    public ResourceKey<StructureTemplatePool> pool() {
        return this.pool;
    }

    public boolean required() {
        return this.required;
    }

    public List<Pair<StructurePoolElement, Integer>> elements() {
        return this.elements;
    }
}

