/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox;

import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.sandbox.EmptySurfaceRule;
import org.moddingx.libx.impl.sandbox.density.DensityClamp;
import org.moddingx.libx.impl.sandbox.density.DensityDebug;
import org.moddingx.libx.impl.sandbox.density.DensityInfluence;
import org.moddingx.libx.impl.sandbox.density.DensityLerp;
import org.moddingx.libx.impl.sandbox.density.DensitySmash;
import org.moddingx.libx.sandbox.generator.BiomeLayer;
import org.moddingx.libx.sandbox.structure.PoolExtension;
import org.moddingx.libx.sandbox.surface.BiomeSurface;
import org.moddingx.libx.sandbox.surface.SurfaceRuleSet;

public class SandBox {
    public static final ResourceKey<Registry<SurfaceRuleSet>> SURFACE_RULE_SET = ResourceKey.createRegistryKey((ResourceLocation)LibX.getInstance().resource("surface_rule_set"));
    public static final ResourceKey<Registry<BiomeSurface>> BIOME_SURFACE = ResourceKey.createRegistryKey((ResourceLocation)LibX.getInstance().resource("biome_surface"));
    public static final ResourceKey<Registry<BiomeLayer>> BIOME_LAYER = ResourceKey.createRegistryKey((ResourceLocation)LibX.getInstance().resource("biome_layer"));
    public static final ResourceKey<Registry<PoolExtension>> TEMPLATE_POOL_EXTENSION = ResourceKey.createRegistryKey((ResourceLocation)LibX.getInstance().resource("template_pool_extension"));

    public static SurfaceRules.RuleSource emptySurface() {
        return EmptySurfaceRule.INSTANCE;
    }

    public static class Density {
        private Density() {
        }

        public static DensityFunction smashX(DensityFunction density) {
            return Density.smash(density, Direction.Axis.X);
        }

        public static DensityFunction smashY(DensityFunction density) {
            return Density.smash(density, Direction.Axis.Y);
        }

        public static DensityFunction smashZ(DensityFunction density) {
            return Density.smash(density, Direction.Axis.Z);
        }

        public static DensityFunction smash(DensityFunction density, Direction.Axis axis) {
            return new DensitySmash(density, axis);
        }

        public static DensityFunction influence(DensityFunction base, DensityFunction modifier, DensityFunction influence) {
            return new DensityInfluence(base, modifier, influence, influence.minValue(), influence.maxValue());
        }

        public static DensityFunction influence(DensityFunction base, DensityFunction modifier, DensityFunction influence, double minInfluence, double maxInfluence) {
            if (!Double.isFinite(minInfluence)) {
                throw new IllegalArgumentException("Invalid minimum influence: " + minInfluence);
            }
            if (!Double.isFinite(maxInfluence)) {
                throw new IllegalArgumentException("Invalid maximum influence: " + maxInfluence);
            }
            return new DensityInfluence(base, modifier, influence, minInfluence, maxInfluence);
        }

        public static DensityFunction debug(Direction.Axis axis, double scale) {
            return new DensityDebug(axis, scale);
        }

        public static DensityFunction lerp(DensityFunction a, DensityFunction b, DensityFunction niveau) {
            return Density.lerp(a, b, niveau, 0.0, 1.0);
        }

        public static DensityFunction lerp(DensityFunction a, DensityFunction b, DensityFunction niveau, double mean, double deviation) {
            return new DensityLerp(a, b, niveau, mean, deviation);
        }

        public static DensityFunction clamp(DensityFunction density, double min, double max) {
            return new DensityClamp(density, min, max);
        }
    }
}

