/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.network;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.network.PacketHandler;

public abstract class NetworkX {
    private final Object lock = new Object();
    private final ModX mod;
    private final String version;
    @Nullable
    private HashSet<String> usedIds;
    private final List<PacketType<?>> packetTypes;

    protected NetworkX(ModX mod) {
        this.mod = mod;
        this.version = this.getVersion();
        this.usedIds = new HashSet();
        this.packetTypes = new ArrayList();
        ModInternal.get(this.mod).modEventBus().addListener(this::runRegistration);
    }

    protected abstract String getVersion();

    protected final <T extends CustomPacketPayload> void register(PacketHandler<T> handler) {
        this.doRegister(handler, false);
    }

    protected final <T extends CustomPacketPayload> void registerOptional(PacketHandler<T> handler) {
        this.doRegister(handler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends CustomPacketPayload> void doRegister(PacketHandler<T> handler, boolean optional) {
        Object object = this.lock;
        synchronized (object) {
            CustomPacketPayload.Type<T> type = handler.type();
            if (!Objects.equals(this.mod.modid, type.id().getNamespace())) {
                throw new IllegalArgumentException("Invalid packet namespace " + type.id().getNamespace() + ", expected " + this.mod.modid);
            }
            if (this.usedIds == null) {
                throw new IllegalStateException("Network packet handler registered too late.");
            }
            if (!this.usedIds.add(type.id().getPath())) {
                throw new IllegalStateException("Duplicate packet id: " + String.valueOf(type.id()));
            }
            this.packetTypes.add(new PacketType<T>(type, handler, optional));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRegistration(RegisterPayloadHandlersEvent event) {
        Object object = this.lock;
        synchronized (object) {
            for (PacketType<?> packetType : this.packetTypes) {
                this.registerHandler(event, packetType);
            }
            this.usedIds = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends CustomPacketPayload> void registerHandler(RegisterPayloadHandlersEvent event, PacketType<T> packetType) {
        Object object = this.lock;
        synchronized (object) {
            PayloadRegistrar registrar = event.registrar(this.version).executesOn(packetType.handler().target());
            if (packetType.optional()) {
                registrar = registrar.optional();
            }
            Object var5_5 = switch (packetType.handler().direction()) {
                default -> throw new MatchException(null, null);
                case PacketFlow.CLIENTBOUND -> {
                    registrar.playToClient(packetType.type(), packetType.handler().codec(), new WrappedHandler<T>(packetType.handler()));
                    yield null;
                }
                case PacketFlow.SERVERBOUND -> {
                    registrar.playToServer(packetType.type(), packetType.handler().codec(), new WrappedHandler<T>(packetType.handler()));
                    yield null;
                }
            };
        }
    }

    public boolean canSend(CustomPacketPayload.Type<?> type) {
        return switch (FMLLoader.getDist()) {
            default -> throw new MatchException(null, null);
            case Dist.CLIENT -> ClientCanSendCheck.canSendOnClient(type);
            case Dist.DEDICATED_SERVER -> true;
        };
    }

    public boolean canSend(ServerPlayer player, CustomPacketPayload.Type<?> type) {
        return player.connection.hasChannel(type);
    }

    private record PacketType<T extends CustomPacketPayload>(CustomPacketPayload.Type<T> type, PacketHandler<T> handler, boolean optional) {
    }

    private record WrappedHandler<T extends CustomPacketPayload>(PacketHandler<T> handler) implements IPayloadHandler<T>
    {
        public void handle(@Nonnull T payload, @Nonnull IPayloadContext context) {
            this.handler().handle(payload, context);
        }
    }

    private static class ClientCanSendCheck {
        private ClientCanSendCheck() {
        }

        public static boolean canSendOnClient(CustomPacketPayload.Type<?> type) {
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            return connection != null && connection.hasChannel(type);
        }
    }
}

