/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.mod;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.moddingx.libx.impl.ModInternal;
import org.moddingx.libx.impl.config.ModMappers;
import org.moddingx.libx.mod.ModXRegistration;

public abstract class ModX {
    public final String modid;

    protected ModX() {
        Class<?> cls = this.getClass();
        Mod mod = cls.getAnnotation(Mod.class);
        if (mod == null) {
            throw new IllegalStateException("Mod class has no @Mod annotation.");
        }
        this.modid = mod.value();
        ModInternal modInternal = ModInternal.init(this);
        modInternal.modEventBus().addListener(this::setup);
        modInternal.modEventBus().addListener(this::clientSetup);
        ModMappers.get(this.modid).initAdapter((ModContainer)modInternal.modContainer());
        if (!(this instanceof ModXRegistration)) {
            ModInternal.get(this).callGeneratedCode();
        }
    }

    protected abstract void setup(FMLCommonSetupEvent var1);

    protected abstract void clientSetup(FMLClientSetupEvent var1);

    public final ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)path);
    }
}

