/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.menu;

import com.mojang.datafixers.util.Function4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public abstract class MenuBase
extends AbstractContainerMenu {
    public final IItemHandler playerInventory;

    protected MenuBase(@Nullable MenuType<?> type, int id, Inventory inventory) {
        super(type, id);
        this.playerInventory = new InvWrapper((Container)inventory);
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        return this.addSlotBox(handler, index, x, y, horAmount, dx, verAmount, dy, (Function4<IItemHandler, Integer, Integer, Integer, Slot>)((Function4)SlotItemHandler::new));
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        return this.addSlotRange(handler, index, x, y, amount, dx, (Function4<IItemHandler, Integer, Integer, Integer, Slot>)((Function4)SlotItemHandler::new));
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy, Function4<IItemHandler, Integer, Integer, Integer, Slot> slotFactory) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx, slotFactory);
            y += dy;
        }
        return index;
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx, Function4<IItemHandler, Integer, Integer, Integer, Slot> slotFactory) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)slotFactory.apply((Object)handler, (Object)index, (Object)x, (Object)y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected boolean moveItemStackTo(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack content;
        Slot slot;
        int idx;
        boolean success = false;
        if (stack.isStackable()) {
            int n = idx = reverseDirection ? endIndex - 1 : startIndex;
            while (!stack.isEmpty() && !(!reverseDirection ? idx >= endIndex : idx < startIndex)) {
                slot = (Slot)this.slots.get(idx);
                content = slot.getItem();
                if (!content.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)content) && slot.mayPlace(stack)) {
                    int maxSize;
                    int totalCount = content.getCount() + stack.getCount();
                    if (totalCount <= (maxSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize()))) {
                        stack.setCount(0);
                        content.setCount(totalCount);
                        slot.setChanged();
                        success = true;
                    } else if (content.getCount() < maxSize) {
                        stack.shrink(maxSize - content.getCount());
                        content.setCount(maxSize);
                        slot.setChanged();
                        success = true;
                    }
                }
                idx += reverseDirection ? -1 : 1;
            }
        }
        if (!stack.isEmpty()) {
            int n = idx = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? idx >= endIndex : idx < startIndex)) {
                slot = (Slot)this.slots.get(idx);
                content = slot.getItem();
                if (content.isEmpty() && slot.mayPlace(stack)) {
                    if (stack.getCount() > slot.getMaxStackSize()) {
                        slot.set(stack.split(slot.getMaxStackSize()));
                    } else {
                        slot.set(stack.split(stack.getCount()));
                    }
                    slot.setChanged();
                    success = true;
                    break;
                }
                idx += reverseDirection ? -1 : 1;
            }
        }
        return success;
    }
}

