/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.inventory;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.moddingx.libx.codec.MoreStreamCodecs;
import org.moddingx.libx.inventory.IAdvancedItemHandlerModifiable;

public class StackItemHandler
implements IAdvancedItemHandlerModifiable {
    public static final DataComponentType<NonNullList<ItemStack>> INVENTORY_DATA = new DataComponentType.Builder().persistent(NonNullList.codecOf((Codec)ItemStack.OPTIONAL_CODEC)).networkSynchronized(MoreStreamCodecs.listOf(ItemStack.OPTIONAL_STREAM_CODEC).map(NonNullList::copyOf, Function.identity())).build();
    private final int size;
    protected final MutableDataComponentHolder dataComponentHolder;

    public StackItemHandler(int size, MutableDataComponentHolder dataComponentHolder) {
        this.size = size;
        this.dataComponentHolder = dataComponentHolder;
    }

    public int getSlots() {
        return this.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> stacks = this.getContents();
        if (slot < stacks.size()) {
            return (ItemStack)stacks.get(slot);
        }
        return ItemStack.EMPTY;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> newStacks = this.copyContentsPossiblyEnlarged(this.getContents());
        newStacks.set(slot, (Object)stack.copy());
        this.dataComponentHolder.set(INVENTORY_DATA, newStacks);
    }

    @Override
    public void clear() {
        this.clear(stack -> true);
    }

    @Override
    public int clear(Predicate<ItemStack> predicate) {
        NonNullList<ItemStack> newStacks = this.copyContentsPossiblyEnlarged(this.getContents());
        int cleared = 0;
        for (int i = 0; i < this.size; ++i) {
            ItemStack stack = (ItemStack)newStacks.get(i);
            if (!predicate.test(stack)) continue;
            cleared += stack.getCount();
            newStacks.set(i, (Object)ItemStack.EMPTY);
        }
        this.dataComponentHolder.set(INVENTORY_DATA, newStacks);
        return cleared;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int insertAmount;
        this.validateSlotIndex(slot);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        NonNullList<ItemStack> oldStacks = this.getContents();
        ItemStack existing = slot < oldStacks.size() ? (ItemStack)oldStacks.get(slot) : ItemStack.EMPTY;
        int limit = Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if ((insertAmount = Math.min(stack.getCount(), limit)) <= 0) {
            return stack;
        }
        ItemStack newStack = stack.copyWithCount(existing.getCount() + insertAmount);
        ItemStack remainder = stack.copyWithCount(stack.getCount() - insertAmount);
        if (!simulate) {
            this.setStackInSlot(slot, newStack);
        }
        return remainder;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack existing;
        this.validateSlotIndex(slot);
        NonNullList<ItemStack> oldStacks = this.getContents();
        ItemStack itemStack = existing = slot < oldStacks.size() ? (ItemStack)oldStacks.get(slot) : ItemStack.EMPTY;
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int extractAmount = Math.min(existing.getCount(), amount);
        ItemStack extractStack = existing.copyWithCount(extractAmount);
        ItemStack remainder = existing.copyWithCount(existing.getCount() - extractAmount);
        if (!simulate) {
            this.setStackInSlot(slot, remainder);
        }
        return extractStack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    private NonNullList<ItemStack> getContents() {
        return (NonNullList)this.dataComponentHolder.getOrDefault(INVENTORY_DATA, (Object)NonNullList.create());
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    private NonNullList<ItemStack> copyContentsPossiblyEnlarged(NonNullList<ItemStack> oldStacks) {
        NonNullList newStacks = NonNullList.withSize((int)Math.max(this.size, oldStacks.size()), (Object)ItemStack.EMPTY);
        for (int i = 0; i < oldStacks.size(); ++i) {
            newStacks.set(i, (Object)((ItemStack)oldStacks.get(i)).copy());
        }
        return newStacks;
    }
}

