/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.inventory;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.moddingx.libx.impl.inventory.AdvancedItemHandlerHelper;
import org.moddingx.libx.inventory.IAdvancedItemHandlerModifiable;

public interface IAdvancedItemHandler
extends IItemHandler {
    default public ItemStack insertItem(ItemStack stack, boolean simulate) {
        ItemStack remainder = stack.copy();
        for (int slot = 0; slot < this.getSlots() && !(remainder = this.insertItem(slot, stack, simulate)).isEmpty(); ++slot) {
        }
        return remainder;
    }

    default public boolean hasSpaceFor(List<ItemStack> stacks) {
        return this.hasSpaceFor(stacks, 0, this.getSlots());
    }

    default public boolean hasSpaceFor(List<ItemStack> stacks, int startInclusive, int endExclusive) {
        return AdvancedItemHandlerHelper.hasSpaceFor(this, stacks, startInclusive, endExclusive, (arg_0, arg_1) -> ((IAdvancedItemHandler)this).isItemValid(arg_0, arg_1));
    }

    default public ItemStack extractItem(int amount, boolean simulate) {
        return this.extractItem(stack -> true, amount, simulate);
    }

    default public ItemStack extractItem(Predicate<ItemStack> predicate, int amount, boolean simulate) {
        ItemStack extracted = ItemStack.EMPTY;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            int amountToExtract = Math.max(0, amount - extracted.getCount());
            ItemStack content = this.extractItem(slot, amountToExtract, true);
            if (extracted.isEmpty()) {
                if (predicate.test(content)) {
                    extracted = content;
                    if (!simulate) {
                        this.extractItem(slot, amountToExtract, false);
                    }
                }
            } else if (ItemStack.isSameItemSameComponents((ItemStack)extracted, (ItemStack)content)) {
                extracted.grow(content.getCount());
                if (!simulate) {
                    this.extractItem(slot, amountToExtract, false);
                }
            }
            if (extracted.getCount() >= amount) break;
        }
        return extracted;
    }

    public static IAdvancedItemHandler wrap(final IItemHandler handler) {
        if (handler instanceof IAdvancedItemHandler) {
            IAdvancedItemHandler advanced = (IAdvancedItemHandler)handler;
            return advanced;
        }
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
            return IAdvancedItemHandlerModifiable.wrap(modifiable);
        }
        return new IAdvancedItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return handler.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return handler.isItemValid(slot, stack);
            }
        };
    }
}

