/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.screen.text;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.screen.text.entry.AlignedComponent;
import org.moddingx.libx.screen.text.entry.AlignedWidget;
import org.moddingx.libx.screen.text.entry.FlowBox;
import org.moddingx.libx.screen.text.entry.TextScreenEntry;

public class TextScreenContent {
    private final Font font;
    private final List<PlacedText> lines;
    private final List<PlacedWidget> widgets;
    private final int width;
    private final int height;

    public TextScreenContent(Font font, int totalWidth, List<? extends TextScreenEntry> components) {
        ImmutableList.Builder list = ImmutableList.builder();
        ImmutableList.Builder widgets = ImmutableList.builder();
        int height = 0;
        for (TextScreenEntry textScreenEntry : components) {
            int totalFlowBoxWidth;
            if (textScreenEntry instanceof TextScreenEntry.Direct) {
                TextScreenEntry.Direct direct = (TextScreenEntry.Direct)textScreenEntry;
                DirectElementBox box = TextScreenContent.wrapElement(font, totalWidth, direct, false);
                box.placeAt(0, height, (ImmutableList.Builder<PlacedText>)list, (ImmutableList.Builder<PlacedWidget>)widgets);
                height += box.height;
                continue;
            }
            if (!(textScreenEntry instanceof FlowBox)) continue;
            FlowBox flowBox = (FlowBox)textScreenEntry;
            height += flowBox.top();
            ArrayList<DirectElementBox> row = new ArrayList<DirectElementBox>();
            int remainingWidth = totalFlowBoxWidth = Math.max(totalWidth - flowBox.left() - flowBox.right(), 1);
            for (TextScreenEntry.Direct direct : flowBox.elements()) {
                DirectElementBox box = TextScreenContent.wrapElement(font, remainingWidth, direct, row.isEmpty());
                if (box.width() > remainingWidth && remainingWidth < totalFlowBoxWidth) {
                    height += TextScreenContent.placeRow(flowBox.horizontalAlignment(), flowBox.verticalAlignment(), row, flowBox.left(), height, totalFlowBoxWidth, (ImmutableList.Builder<PlacedText>)list, (ImmutableList.Builder<PlacedWidget>)widgets);
                    row.clear();
                    remainingWidth = totalFlowBoxWidth;
                    box = TextScreenContent.wrapElement(font, remainingWidth, direct, row.isEmpty());
                }
                remainingWidth = Math.max(remainingWidth - box.width, 0);
                row.add(box);
            }
            height += TextScreenContent.placeRow(flowBox.horizontalAlignment(), flowBox.verticalAlignment(), row, flowBox.left(), height, totalWidth, (ImmutableList.Builder<PlacedText>)list, (ImmutableList.Builder<PlacedWidget>)widgets);
        }
        this.font = font;
        this.lines = list.build();
        this.widgets = widgets.build();
        this.width = totalWidth;
        this.height = height;
    }

    private static DirectElementBox wrapElement(Font font, int maxWidth, TextScreenEntry.Direct entry, boolean suppressLeft) {
        int theLeft;
        if (maxWidth == 0) {
            maxWidth = 1;
        }
        int n = theLeft = suppressLeft ? 0 : entry.left();
        if (entry instanceof AlignedComponent) {
            AlignedComponent component = (AlignedComponent)entry;
            int width = 0;
            int height = 0;
            ImmutableList.Builder list = ImmutableList.builder();
            List lines = component.wrapping() != null ? ComponentRenderUtils.wrapComponents((FormattedText)component.text(), (int)Math.max(component.wrapping().minWidth(), maxWidth), (Font)font) : List.of(Language.getInstance().getVisualOrder((FormattedText)component.text()));
            boolean first = true;
            for (FormattedCharSequence line : lines) {
                if (first) {
                    height += component.top();
                    first = false;
                } else {
                    height += 2;
                }
                width = Math.max(width, theLeft + font.width(line));
                list.add((Object)new PlacedText(line, theLeft, height, 0xFFFFFF & component.color(), component.shadow()));
                Objects.requireNonNull(font);
                height += 9;
            }
            return new DirectElementBox((List<PlacedText>)list.build(), List.of(), width, height, first ? 0 : component.top());
        }
        if (entry instanceof AlignedWidget) {
            AlignedWidget widget = (AlignedWidget)entry;
            int width = theLeft + widget.widget().getWidth();
            int height = widget.top() + widget.widget().getHeight();
            return new DirectElementBox(List.of(), List.of(new PlacedWidget(widget.widget(), theLeft, widget.top())), width, height, widget.top());
        }
        return new DirectElementBox(List.of(), List.of(), 0, 0, 0);
    }

    private static int placeRow(FlowBox.HorizontalAlignment hor, FlowBox.VerticalAlignment ver, List<DirectElementBox> boxes, int globalXOff, int currentHeight, int totalWidth, ImmutableList.Builder<PlacedText> list, ImmutableList.Builder<PlacedWidget> widgets) {
        if (boxes.isEmpty()) {
            return 0;
        }
        if (boxes.size() == 1 && hor == FlowBox.HorizontalAlignment.FILL) {
            hor = FlowBox.HorizontalAlignment.CENTER;
        }
        int combinedWidth = 0;
        int maximumTopPadding = 0;
        int maximumContentHeight = 0;
        for (DirectElementBox box : boxes) {
            combinedWidth += box.width();
            maximumTopPadding = Math.max(maximumTopPadding, box.topPadding());
            maximumContentHeight = Math.max(maximumContentHeight, box.contentHeight());
        }
        int xOff = globalXOff + (switch (hor) {
            default -> throw new MatchException(null, null);
            case FlowBox.HorizontalAlignment.LEFT, FlowBox.HorizontalAlignment.FILL -> 0;
            case FlowBox.HorizontalAlignment.RIGHT -> totalWidth - combinedWidth;
            case FlowBox.HorizontalAlignment.CENTER -> (totalWidth - combinedWidth) / 2;
        });
        int distributedWidth = switch (hor) {
            default -> throw new MatchException(null, null);
            case FlowBox.HorizontalAlignment.LEFT, FlowBox.HorizontalAlignment.RIGHT, FlowBox.HorizontalAlignment.CENTER -> 0;
            case FlowBox.HorizontalAlignment.FILL -> (totalWidth - combinedWidth) / (boxes.size() - 1);
        };
        int remainingDistributedWidth = switch (hor) {
            default -> throw new MatchException(null, null);
            case FlowBox.HorizontalAlignment.LEFT, FlowBox.HorizontalAlignment.RIGHT, FlowBox.HorizontalAlignment.CENTER -> 0;
            case FlowBox.HorizontalAlignment.FILL -> totalWidth - combinedWidth - (boxes.size() - 1) * distributedWidth;
        };
        for (int i = 0; i < boxes.size(); ++i) {
            DirectElementBox box = boxes.get(i);
            if (i == boxes.size() - 1) {
                xOff += remainingDistributedWidth;
            }
            int yOff = switch (ver) {
                default -> throw new MatchException(null, null);
                case FlowBox.VerticalAlignment.TOP -> maximumTopPadding - box.topPadding();
                case FlowBox.VerticalAlignment.CENTER -> maximumTopPadding - box.topPadding() + (maximumContentHeight - box.contentHeight()) / 2;
                case FlowBox.VerticalAlignment.BOTTOM -> maximumTopPadding - box.topPadding() + maximumContentHeight - box.contentHeight();
            };
            box.placeAt(xOff, currentHeight + yOff, list, widgets);
            xOff += box.width();
            xOff += distributedWidth;
        }
        return maximumTopPadding + maximumContentHeight;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void addWidgets(int left, int top, Consumer<? super AbstractWidget> consumer) {
        for (PlacedWidget widget : this.widgets) {
            widget.widget().setX(widget.x() + left);
            widget.widget().setY(widget.y() + top);
            consumer.accept((AbstractWidget)widget.widget());
        }
    }

    public void render(GuiGraphics graphics, int left, int top) {
        for (PlacedText line : this.lines) {
            RenderHelper.resetColor();
            graphics.drawString(this.font, line.text(), left + line.x(), top + line.y(), line.color(), line.shadow());
        }
    }

    @Nullable
    public Style hoveredStyle(int mouseX, int mouseY) {
        for (PlacedText line : this.lines) {
            if (mouseX < line.x() || mouseX > line.x() + this.font.width(line.text()) || mouseY < line.y()) continue;
            int n = line.y();
            Objects.requireNonNull(this.font);
            if (mouseY > n + 9) continue;
            int relX = mouseX - line.x();
            Style style = this.font.getSplitter().componentStyleAtWidth(line.text(), relX);
            if (style == null) continue;
            return style;
        }
        return null;
    }

    private record DirectElementBox(List<PlacedText> text, List<PlacedWidget> widgets, int width, int height, int topPadding) {
        public int contentHeight() {
            return Math.max(this.height() - this.topPadding(), 0);
        }

        public void placeAt(int x, int y, ImmutableList.Builder<PlacedText> list, ImmutableList.Builder<PlacedWidget> widgets) {
            for (PlacedText text : this.text()) {
                list.add((Object)new PlacedText(text.text(), x + text.x(), y + text.y(), text.color(), text.shadow()));
            }
            for (PlacedWidget widget : this.widgets()) {
                widgets.add((Object)new PlacedWidget(widget.widget(), x + widget.x(), y + widget.y()));
            }
        }
    }

    private record PlacedText(FormattedCharSequence text, int x, int y, int color, boolean shadow) {
    }

    private record PlacedWidget(AbstractWidget widget, int x, int y) {
    }
}

