/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.sandbox.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.blending.Blender;

public class DensitySmash
implements DensityFunction {
    public static final KeyDispatchDataCodec<DensitySmash> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("density").forGetter(d -> d.wrapped), (App)Direction.Axis.CODEC.fieldOf("axis").forGetter(d -> d.axis)).apply((Applicative)instance, DensitySmash::new)));
    private final DensityFunction wrapped;
    private final Direction.Axis axis;
    private final SmashedContext context;
    private final SmashedProvider provider;

    public DensitySmash(DensityFunction wrapped, Direction.Axis axis) {
        this.wrapped = wrapped;
        this.axis = axis;
        this.context = new SmashedContext();
        this.provider = new SmashedProvider();
    }

    @Nonnull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }

    public double compute(@Nonnull DensityFunction.FunctionContext context) {
        this.context.parent = context;
        return this.wrapped.compute((DensityFunction.FunctionContext)this.context);
    }

    public void fillArray(@Nonnull double[] array, @Nonnull DensityFunction.ContextProvider provider) {
        this.provider.parent = provider;
        this.wrapped.fillArray(array, provider);
    }

    @Nonnull
    public DensityFunction mapAll(@Nonnull DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new DensitySmash(this.wrapped.mapAll(visitor), this.axis));
    }

    public double minValue() {
        return this.wrapped.minValue();
    }

    public double maxValue() {
        return this.wrapped.maxValue();
    }

    @Nonnull
    public DensityFunction clamp(double minValue, double maxValue) {
        return new DensitySmash(this.wrapped.clamp(minValue, maxValue), this.axis);
    }

    @Nonnull
    public DensityFunction abs() {
        return new DensitySmash(this.wrapped.abs(), this.axis);
    }

    @Nonnull
    public DensityFunction square() {
        return new DensitySmash(this.wrapped.square(), this.axis);
    }

    @Nonnull
    public DensityFunction cube() {
        return new DensitySmash(this.wrapped.cube(), this.axis);
    }

    @Nonnull
    public DensityFunction halfNegative() {
        return new DensitySmash(this.wrapped.halfNegative(), this.axis);
    }

    @Nonnull
    public DensityFunction quarterNegative() {
        return new DensitySmash(this.wrapped.quarterNegative(), this.axis);
    }

    @Nonnull
    public DensityFunction squeeze() {
        return new DensitySmash(this.wrapped.squeeze(), this.axis);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DensitySmash)) {
            return false;
        }
        DensitySmash other = (DensitySmash)obj;
        return Objects.equals(this.wrapped, other.wrapped) && this.axis == other.axis;
    }

    public int hashCode() {
        return Objects.hash(this.wrapped, this.axis);
    }

    public String toString() {
        return "DensitySmash[wrapped=" + String.valueOf(this.wrapped) + ", axis=" + String.valueOf(this.axis) + "]";
    }

    private class SmashedContext
    implements DensityFunction.FunctionContext {
        private DensityFunction.FunctionContext parent;

        private SmashedContext() {
        }

        public int blockX() {
            return DensitySmash.this.axis == Direction.Axis.X ? 0 : this.parent.blockX();
        }

        public int blockY() {
            return DensitySmash.this.axis == Direction.Axis.Y ? 0 : this.parent.blockY();
        }

        public int blockZ() {
            return DensitySmash.this.axis == Direction.Axis.Z ? 0 : this.parent.blockZ();
        }

        @Nonnull
        public Blender getBlender() {
            return this.parent.getBlender();
        }
    }

    private class SmashedProvider
    implements DensityFunction.ContextProvider {
        private DensityFunction.ContextProvider parent;

        private SmashedProvider() {
        }

        @Nonnull
        public DensityFunction.FunctionContext forIndex(int arrayIndex) {
            DensitySmash.this.context.parent = this.parent.forIndex(arrayIndex);
            return DensitySmash.this.context;
        }

        public void fillAllDirectly(@Nonnull double[] values, @Nonnull DensityFunction function) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = function.compute(this.forIndex(i));
            }
        }
    }
}

