/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.sandbox.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record DensityLerp(DensityFunction argument1, DensityFunction argument2, DensityFunction niveau, double mean, double deviation) implements DensityFunction
{
    public static final KeyDispatchDataCodec<DensityLerp> CODEC = KeyDispatchDataCodec.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument1").forGetter(DensityLerp::argument1), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument2").forGetter(DensityLerp::argument2), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("niveau").forGetter(DensityLerp::niveau), (App)Codec.DOUBLE.optionalFieldOf("mean", (Object)0.0).forGetter(DensityLerp::mean), (App)Codec.DOUBLE.optionalFieldOf("deviation", (Object)1.0).forGetter(DensityLerp::deviation)).apply((Applicative)instance, DensityLerp::new)));

    @Nonnull
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }

    public double compute(@Nonnull DensityFunction.FunctionContext context) {
        double a = this.argument1().compute(context);
        double b = this.argument2().compute(context);
        double n = Mth.clamp((double)this.niveau().compute(context), (double)(this.mean() - this.deviation()), (double)(this.mean() + this.deviation()));
        return Mth.lerp((double)((n - this.mean()) / (2.0 * this.deviation()) + 0.5), (double)a, (double)b);
    }

    public void fillArray(@Nonnull double[] array, @Nonnull DensityFunction.ContextProvider provider) {
        double[] a = new double[array.length];
        double[] b = new double[array.length];
        this.niveau().fillArray(array, provider);
        this.argument1().fillArray(a, provider);
        this.argument2().fillArray(b, provider);
        for (int i = 0; i < array.length; ++i) {
            double n = Mth.clamp((double)array[i], (double)(this.mean() - this.deviation()), (double)(this.mean() + this.deviation()));
            array[i] = Mth.lerp((double)((n - this.mean()) / (2.0 * this.deviation()) + 0.5), (double)a[i], (double)b[i]);
        }
    }

    @Nonnull
    public DensityFunction mapAll(@Nonnull DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new DensityLerp(this.argument1().mapAll(visitor), this.argument2().mapAll(visitor), this.niveau().mapAll(visitor), this.mean(), this.deviation()));
    }

    public double minValue() {
        return Math.min(this.argument1().minValue(), this.argument2().minValue());
    }

    public double maxValue() {
        return Math.max(this.argument1().maxValue(), this.argument2().maxValue());
    }
}

