/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.sandbox;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class FakeHolder<T>
implements Holder<T> {
    private Holder<T> holder;

    public FakeHolder(Holder<T> initial) {
        this.set(initial);
    }

    public void set(Holder<T> value) {
        try {
            value.value();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Unbound holder: " + String.valueOf(value), e);
        }
        this.holder = value;
    }

    @Nonnull
    public T value() {
        return (T)this.holder.value();
    }

    public boolean isBound() {
        return true;
    }

    public boolean is(@Nonnull ResourceLocation id) {
        return false;
    }

    public boolean is(@Nonnull ResourceKey<T> key) {
        return false;
    }

    public boolean is(@Nonnull Predicate<ResourceKey<T>> predicate) {
        return false;
    }

    public boolean is(@Nonnull TagKey<T> key) {
        return false;
    }

    @Deprecated
    public boolean is(@Nonnull Holder<T> holder) {
        return false;
    }

    @Nonnull
    public Stream<TagKey<T>> tags() {
        return Stream.empty();
    }

    @Nonnull
    public Either<ResourceKey<T>, T> unwrap() {
        return Either.right(this.value());
    }

    @Nonnull
    public Optional<ResourceKey<T>> unwrapKey() {
        return Optional.empty();
    }

    @Nonnull
    public Holder.Kind kind() {
        return Holder.Kind.DIRECT;
    }

    public boolean canSerializeIn(@Nonnull HolderOwner<T> owner) {
        return true;
    }
}

