/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.render;

import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;

public class BlockOverlayQuadCache {
    private static final WeakHashMap<TextureAtlasSprite, WeakHashMap<BakedQuad, BakedQuad>> quadCache = new WeakHashMap();

    @Nullable
    public static BakedQuad get(BakedQuad source, TextureAtlasSprite sprite) {
        WeakHashMap quads = quadCache.computeIfAbsent(sprite, k -> new WeakHashMap());
        return (BakedQuad)quads.get(source);
    }

    public static void put(BakedQuad source, BakedQuad transformed) {
        WeakHashMap quads = quadCache.computeIfAbsent(transformed.getSprite(), k -> new WeakHashMap());
        quads.put(source, transformed);
    }

    public static void resourcesReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<Void>(){

            @Nonnull
            protected Void prepare(@Nonnull ResourceManager rm, @Nonnull ProfilerFiller filler) {
                return null;
            }

            protected void apply(@Nonnull Void obj, @Nonnull ResourceManager rm, @Nonnull ProfilerFiller filler) {
                quadCache.clear();
            }
        });
    }
}

