/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.registration.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.moddingx.libx.impl.registration.handler.SpecialRegistrationHandler;
import org.moddingx.libx.registration.util.CapabilityInfo;

public class CapabilityRegistrationHandler
extends SpecialRegistrationHandler {
    private final Map<ResourceLocation, CapabilityInfo.Item<?, ?>> items = new HashMap();
    private final Map<ResourceLocation, CapabilityInfo.Block<?, ?>> blocks = new HashMap();
    private final Map<ResourceLocation, CapabilityInfo.BlockEntity<?, ?, ?>> blockEntities = new HashMap();
    private final Map<ResourceLocation, CapabilityInfo.Entity<?, ?, ?>> entities = new HashMap();

    public CapabilityRegistrationHandler(Runnable runRegistration) {
        super(runRegistration);
    }

    @Override
    public void handle(ResourceLocation id, Object object) {
        if (object instanceof CapabilityInfo.Item) {
            CapabilityInfo.Item itemInfo = (CapabilityInfo.Item)object;
            this.addToMap("CapabilityInfo.Item", this.items, id, itemInfo);
        }
        if (object instanceof CapabilityInfo.Block) {
            CapabilityInfo.Block blockInfo = (CapabilityInfo.Block)object;
            this.addToMap("CapabilityInfo.Block", this.blocks, id, blockInfo);
        }
        if (object instanceof CapabilityInfo.BlockEntity) {
            CapabilityInfo.BlockEntity blockEntityInfo = (CapabilityInfo.BlockEntity)object;
            this.addToMap("CapabilityInfo.BlockEntity", this.blockEntities, id, blockEntityInfo);
        }
        if (object instanceof CapabilityInfo.Entity) {
            CapabilityInfo.Entity entityInfo = (CapabilityInfo.Entity)object;
            this.addToMap("CapabilityInfo.Entity", this.entities, id, entityInfo);
        }
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (CapabilityInfo.Item<?, ?> item : this.items.values()) {
            CapabilityRegistrationHandler.registerItemTo(event, item);
        }
        for (CapabilityInfo.Block block : this.blocks.values()) {
            CapabilityRegistrationHandler.registerBlockTo(event, block);
        }
        for (CapabilityInfo.BlockEntity blockEntity : this.blockEntities.values()) {
            CapabilityRegistrationHandler.registerBlockEntityTo(event, blockEntity);
        }
        for (CapabilityInfo.Entity entity : this.entities.values()) {
            CapabilityRegistrationHandler.registerEntityTo(event, entity);
        }
    }

    private static <T, C> void registerItemTo(RegisterCapabilitiesEvent event, CapabilityInfo.Item<T, C> info) {
        event.registerItem(info.capability(), info.provider(), new ItemLike[]{info.item()});
    }

    private static <T, C> void registerBlockTo(RegisterCapabilitiesEvent event, CapabilityInfo.Block<T, C> info) {
        event.registerBlock(info.capability(), info.provider(), new Block[]{info.block()});
    }

    private static <BE extends BlockEntity, T, C> void registerBlockEntityTo(RegisterCapabilitiesEvent event, CapabilityInfo.BlockEntity<BE, T, C> info) {
        event.registerBlockEntity(info.capability(), info.blockEntityType(), info.provider());
    }

    private static <E extends Entity, T, C> void registerEntityTo(RegisterCapabilitiesEvent event, CapabilityInfo.Entity<E, T, C> info) {
        event.registerEntity(info.capability(), info.entityType(), info.provider());
    }
}

