/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.network;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.network.BeUpdateHandler;
import org.moddingx.libx.impl.network.NetworkImpl;
import org.moddingx.libx.network.PacketHandler;

public class BeRequestHandler
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(LibX.getInstance().resource("be_request"));

    protected BeRequestHandler() {
        super(TYPE, PacketFlow.SERVERBOUND, BlockPos.STREAM_CODEC.map(Message::new, Message::pos), HandlerThread.MAIN);
    }

    @Override
    public void handle(Message msg, IPayloadContext ctx) {
        BeUpdateHandler.Message reply;
        ServerPlayer sender;
        ServerLevel level;
        Player player = ctx.player();
        if (player instanceof ServerPlayer && (level = (sender = (ServerPlayer)player).serverLevel()).hasChunkAt(msg.pos()) && NetworkImpl.getImpl().canSend(sender, BeUpdateHandler.TYPE) && (reply = NetworkImpl.getImpl().getBeUpdateMessage(sender.level(), msg.pos())) != null) {
            ctx.reply((CustomPacketPayload)reply);
        }
    }

    public record Message(BlockPos pos) implements CustomPacketPayload
    {
        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

