/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.inventory;

import java.util.HashMap;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class AdvancedItemHandlerHelper {
    public static boolean hasSpaceFor(IItemHandler itemHandler, List<ItemStack> stacks, int startInclusive, int endExclusive, BiPredicate<Integer, ItemStack> itemValidForSlot) {
        if (stacks.isEmpty()) {
            return true;
        }
        if (stacks.size() == 1) {
            ItemStack remainder = stacks.get(0).copy();
            for (int slot = startInclusive; slot < endExclusive; ++slot) {
                if (!(remainder = itemHandler.insertItem(slot, remainder, true)).isEmpty()) continue;
                return true;
            }
            return remainder.isEmpty();
        }
        HashMap<Integer, ItemStack> copies = new HashMap<Integer, ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            int amountLeft = stack.getCount();
            for (int slot = startInclusive; slot < endExclusive; ++slot) {
                if (!itemValidForSlot.test(slot, stack)) continue;
                ItemStack content = copies.getOrDefault(slot, itemHandler.getStackInSlot(slot));
                if (content.isEmpty()) {
                    amountLeft = 0;
                    ItemStack modifiableStack = stack.copy();
                    modifiableStack.setCount(amountLeft);
                    copies.put(slot, modifiableStack);
                    break;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)content)) continue;
                int reduce = Math.max(0, Math.min(content.getMaxStackSize() - content.getCount(), amountLeft));
                ItemStack modifiableStack = copies.getOrDefault(slot, itemHandler.getStackInSlot(slot).copy());
                modifiableStack.grow(reduce);
                copies.put(slot, modifiableStack);
                if ((amountLeft -= reduce) <= 0) break;
            }
            if (amountLeft <= 0) continue;
            return false;
        }
        return true;
    }
}

