/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.registries;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datapack.DatapackHelper;
import org.moddingx.libx.impl.datagen.registries.DatagenRegistrySet;
import org.moddingx.libx.util.lazy.LazyValue;

public class DatagenRegistry<T>
extends MappedRegistry<T> {
    private final DatagenRegistrySet registrySet;
    private final Codec<T> codec;
    private final Lookup lookup;
    private boolean frozen;
    private boolean propagateNewElementsToChildren;

    public static <T> DatagenRegistry<T> createRoot(ResourceKey<? extends Registry<T>> registryKey, DatagenRegistrySet registrySet, Codec<T> codec, Registry<T> rootRegistry) {
        return new DatagenRegistry<T>(registryKey, registrySet, codec, List.of(rootRegistry));
    }

    public static <T> DatagenRegistry<T> create(ResourceKey<? extends Registry<T>> registryKey, DatagenRegistrySet registrySet, Codec<T> codec, List<DatagenRegistry<T>> parents) {
        return new DatagenRegistry<T>(registryKey, registrySet, codec, parents.stream().map(dr -> dr).toList());
    }

    private DatagenRegistry(ResourceKey<? extends Registry<T>> registryKey, DatagenRegistrySet registrySet, Codec<T> codec, List<Registry<T>> fillFrom) {
        super(registryKey, Lifecycle.stable(), true);
        this.registrySet = registrySet;
        this.codec = codec;
        this.lookup = new Lookup();
        this.frozen = false;
        this.propagateNewElementsToChildren = true;
        HashMap parentElements = new HashMap();
        for (Registry<T> registry : fillFrom) {
            for (Map.Entry entry : registry.entrySet()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                Object value = entry.getValue();
                if (parentElements.containsKey(key) && value != parentElements.get(key)) {
                    throw new IllegalStateException("Can't create registry set: Inherited two different values for key " + String.valueOf(key) + ": " + String.valueOf(parentElements.get(key)) + " and " + String.valueOf(value));
                }
                parentElements.put(key, value);
            }
        }
        for (Map.Entry entry : parentElements.entrySet()) {
            this.register((ResourceKey)entry.getKey(), entry.getValue(), RegistrationInfo.BUILT_IN);
        }
    }

    @Nonnull
    public HolderOwner<T> holderOwner() {
        return this.lookup;
    }

    @Nonnull
    public HolderLookup.RegistryLookup<T> asLookup() {
        return this.lookup;
    }

    @Nonnull
    public Holder.Reference<T> register(int id, @Nonnull ResourceKey<T> key, @Nonnull T value, @Nonnull RegistrationInfo info) {
        if (this.unregisteredIntrusiveHolders != null && !this.unregisteredIntrusiveHolders.containsKey(value)) {
            this.createIntrusiveHolder(value);
        }
        Holder.Reference holder = super.register(id, key, value, RegistrationInfo.BUILT_IN);
        if (this.propagateNewElementsToChildren) {
            Set activeChildren = this.registrySet.collectActiveChildRegistries(this.key());
            for (DatagenRegistry child : activeChildren) {
                if (!child.containsKey(key)) continue;
                throw new IllegalStateException("Can't add element to datagen registry: Already registered in child registry");
            }
            for (DatagenRegistry child : activeChildren) {
                child.registerOnlyThisRegistry(key, value, info);
            }
        }
        this.registrySet.trackHolderTarget(holder, this.key());
        return holder;
    }

    @Nonnull
    public Holder.Reference<T> createIntrusiveHolder(@Nonnull T value) {
        Holder.Reference holder = this.getResourceKey(value).flatMap(arg_0 -> ((DatagenRegistry)this).getHolder(arg_0)).orElse(null);
        if (holder == null) {
            holder = super.createIntrusiveHolder(value);
        }
        this.registrySet.trackHolderTarget(holder, this.key());
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder.Reference<T> registerOnlyThisRegistry(ResourceKey<T> key, T value, RegistrationInfo info) {
        try {
            this.propagateNewElementsToChildren = false;
            Holder.Reference reference = this.register(key, value, info);
            return reference;
        }
        finally {
            this.propagateNewElementsToChildren = true;
        }
    }

    @Nonnull
    public Registry<T> freeze() {
        for (DatagenRegistrySet parent : this.registrySet.getDirectParents()) {
            if (!parent.getDatagenRegistry(this.key(), false).stream().anyMatch(reg -> !reg.frozen)) continue;
            throw new IllegalStateException("Can't freeze datagen registry while its parents are still unfrozen.");
        }
        Registry result = super.freeze();
        this.frozen = true;
        return result;
    }

    public void unfreeze() {
        throw new UnsupportedOperationException();
    }

    public void writeOwnElements(PackTarget target, CachedOutput output) {
        if (!this.frozen) {
            throw new IllegalStateException("Can't serialize unfrozen registry: " + String.valueOf(this.key()));
        }
        LazyValue<Path> outputPath = new LazyValue<Path>(() -> target.path(PackType.SERVER_DATA));
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registrySet.registryAccess());
        List parents = this.registrySet.getDirectParents().stream().flatMap(parent -> parent.getDatagenRegistry(this.key(), false).stream()).toList();
        for (Map.Entry entry : this.entrySet()) {
            if (!parents.stream().noneMatch(reg -> reg.containsKey((ResourceKey)entry.getKey()))) continue;
            try {
                JsonElement json = (JsonElement)this.codec.encodeStart((DynamicOps)ops, entry.getValue()).getOrThrow(RuntimeException::new);
                DataProvider.saveStable((CachedOutput)output, (JsonElement)json, (Path)outputPath.get().resolve(DatapackHelper.registryPath((ResourceKey)entry.getKey())));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialise element " + String.valueOf(entry.getKey()) + " in datagen registry", e);
            }
        }
    }

    private class Lookup
    implements HolderLookup.RegistryLookup<T> {
        private Lookup() {
        }

        @Nonnull
        public ResourceKey<? extends Registry<? extends T>> key() {
            return DatagenRegistry.this.key();
        }

        @Nonnull
        public Lifecycle registryLifecycle() {
            return DatagenRegistry.this.registryLifecycle();
        }

        @Nonnull
        public Stream<Holder.Reference<T>> listElements() {
            return DatagenRegistry.this.holders();
        }

        @Nonnull
        public Stream<HolderSet.Named<T>> listTags() {
            return DatagenRegistry.this.getTags().map(Pair::getSecond);
        }

        @Nonnull
        public Optional<Holder.Reference<T>> get(@Nonnull ResourceKey<T> key) {
            return DatagenRegistry.this.getHolder(key);
        }

        @Nonnull
        public Optional<HolderSet.Named<T>> get(@Nonnull TagKey<T> key) {
            return DatagenRegistry.this.getTag(key);
        }

        public boolean canSerializeIn(@Nonnull HolderOwner<T> owner) {
            return true;
        }
    }
}

