/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.crafting.recipe;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.moddingx.libx.LibX;
import org.moddingx.libx.codec.MoreStreamCodecs;

public class EmptyRecipe
implements Recipe<RecipeInput> {
    public static final ResourceLocation ID = LibX.getInstance().resource("empty");
    public static final RecipeType<EmptyRecipe> TYPE = RecipeType.simple((ResourceLocation)ID);

    private EmptyRecipe() {
    }

    public boolean matches(@Nonnull RecipeInput inv, @Nonnull Level level) {
        return false;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull RecipeInput input, @Nonnull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeType<?> getType() {
        return TYPE;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull RecipeInput input) {
        return NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.create();
    }

    public boolean isSpecial() {
        return false;
    }

    @Nonnull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)Blocks.BARRIER);
    }

    public static EmptyRecipe empty() {
        return new EmptyRecipe();
    }

    public static class Serializer
    implements RecipeSerializer<EmptyRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public MapCodec<EmptyRecipe> codec() {
            return MapCodec.unit(EmptyRecipe::new);
        }

        @Nonnull
        public StreamCodec<RegistryFriendlyByteBuf, EmptyRecipe> streamCodec() {
            return MoreStreamCodecs.unit(EmptyRecipe::new);
        }
    }
}

