/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.mappers.special;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.moddingx.libx.LibX;
import org.moddingx.libx.config.correct.ConfigCorrection;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.gui.editor.RecordEditor;
import org.moddingx.libx.impl.config.validators.ConfiguredValidator;
import org.moddingx.libx.impl.config.wrapper.TypesafeMapper;
import org.moddingx.libx.util.ClassUtil;

public class RecordValueMapper<T extends Record>
implements ValueMapper<T, JsonObject> {
    private final Class<T> cls;
    private final List<EntryData> entries;
    private final Constructor<T> ctor;

    public RecordValueMapper(String modid, Class<T> cls, Function<Type, ValueMapper<?, ?>> mapperFunc) {
        this.cls = cls;
        if (!cls.isRecord()) {
            throw new IllegalArgumentException("Can't create record config value mapper for non-record class.");
        }
        RecordComponent[] parts = this.cls.getRecordComponents();
        Class[] types = new Class[parts.length];
        ImmutableList.Builder entries = ImmutableList.builder();
        for (int i = 0; i < parts.length; ++i) {
            types[i] = parts[i].getType();
            TypesafeMapper mapper = TypesafeMapper.of(mapperFunc.apply(parts[i].getGenericType()));
            ConfiguredValidator<?, ?> validator = ConfiguredValidator.create(modid, parts[i]);
            entries.add((Object)new EntryData(mapper, validator));
        }
        this.entries = entries.build();
        if (this.entries.isEmpty()) {
            throw new IllegalArgumentException("Can't create record config value mapper for empty record.");
        }
        try {
            this.ctor = this.cls.getDeclaredConstructor(types);
            this.ctor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Can't create record config value mapper for class: " + String.valueOf(cls), e);
        }
    }

    @Override
    public Class<T> type() {
        return this.cls;
    }

    @Override
    public Class<JsonObject> element() {
        return JsonObject.class;
    }

    @Override
    public T fromJson(JsonObject json) {
        RecordComponent[] parts = this.cls.getRecordComponents();
        Object[] values = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            values[i] = this.entries.get(i).mapper().fromJson(json.get(parts[i].getName()));
        }
        try {
            return (T)((Record)this.ctor.newInstance(values));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to create record for config.", e);
        }
    }

    @Override
    public JsonObject toJson(T value) {
        JsonObject json = new JsonObject();
        RecordComponent[] parts = this.cls.getRecordComponents();
        for (int i = 0; i < parts.length; ++i) {
            try {
                json.add(parts[i].getName(), this.entries.get(i).mapper().toJson(RecordValueMapper.accessComponent(parts[i], value)));
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to get record value for config.", e);
            }
        }
        return json;
    }

    public T validate(T value, String action, List<String> path, @Nullable AtomicBoolean needsCorrection) {
        RecordComponent[] parts = this.cls.getRecordComponents();
        Object[] values = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                List<String> thePath = Stream.concat(path.stream(), Stream.of(parts[i].getName())).toList();
                Object oldValue = RecordValueMapper.accessComponent(parts[i], value);
                ConfiguredValidator<?, ?> validatorUnsafe = this.entries.get(i).validator();
                if (validatorUnsafe != null) {
                    Object newValue = validatorUnsafe.validate(oldValue, action, thePath, needsCorrection);
                    if (!ClassUtil.boxed(parts[i].getType()).isAssignableFrom(newValue.getClass())) {
                        throw new IllegalStateException("A config validator changed the type of a record key: " + String.valueOf(newValue.getClass()) + " (expected " + String.valueOf(parts[i].getType()) + ")");
                    }
                    values[i] = newValue;
                    continue;
                }
                values[i] = oldValue;
                continue;
            }
            catch (ReflectiveOperationException e) {
                LibX.logger.error("Failed to correct record value for config.", (Throwable)e);
                if (needsCorrection != null) {
                    needsCorrection.set(true);
                }
                return value;
            }
        }
        try {
            return (T)((Record)this.ctor.newInstance(values));
        }
        catch (ReflectiveOperationException e) {
            LibX.logger.error("Failed to create record for corrected config.", (Throwable)e);
            if (needsCorrection != null) {
                needsCorrection.set(true);
            }
            return value;
        }
    }

    @Override
    public StreamCodec<? super FriendlyByteBuf, T> streamCodec() {
        return new RecordStreamCodec(this.entries.stream().map(entry -> entry.mapper.streamCodec()).toList());
    }

    @Override
    public Optional<T> correct(JsonElement json, ConfigCorrection<T> correction) {
        RecordComponent[] parts = this.cls.getRecordComponents();
        if (json.isJsonObject()) {
            Object[] args = new Object[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                int idx = i;
                String name = parts[i].getName();
                Optional<Object> obj = correction.tryCorrect(json.getAsJsonObject().has(name) ? json.getAsJsonObject().get(name) : null, this.entries.get(idx).mapper(), record -> {
                    try {
                        return Optional.of(RecordValueMapper.accessComponent(parts[idx], record));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        return Optional.empty();
                    }
                });
                if (!obj.isPresent()) {
                    return Optional.empty();
                }
                args[i] = obj.get();
            }
            try {
                return Optional.of((Record)this.ctor.newInstance(args));
            }
            catch (ReflectiveOperationException e) {
                return Optional.empty();
            }
        }
        if (parts.length == 1) {
            Optional<Object> singleArgValue = correction.tryCorrect(json, this.entries.get(0).mapper(), record -> {
                try {
                    return Optional.of(RecordValueMapper.accessComponent(parts[0], record));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return Optional.empty();
                }
            });
            return singleArgValue.flatMap(value -> {
                try {
                    return Optional.of((Record)this.ctor.newInstance(value));
                }
                catch (ReflectiveOperationException e) {
                    return Optional.empty();
                }
            });
        }
        return Optional.empty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<T> createEditor(ValidatorInfo<?> validator) {
        return new RecordEditor<T>(this.cls, this.entries, this.ctor);
    }

    public static Object accessComponent(RecordComponent component, Object instance) throws InvocationTargetException, IllegalAccessException {
        Method method = component.getAccessor();
        method.setAccessible(true);
        return method.invoke(instance, new Object[0]);
    }

    public record EntryData(TypesafeMapper mapper, @Nullable ConfiguredValidator<?, ?> validator) {
    }

    private class RecordStreamCodec
    implements StreamCodec<FriendlyByteBuf, T> {
        private final List<StreamCodec<? super FriendlyByteBuf, Object>> streamCodecs;

        public RecordStreamCodec(List<StreamCodec<? super FriendlyByteBuf, Object>> streamCodecs) {
            this.streamCodecs = List.copyOf(streamCodecs);
            if (RecordValueMapper.this.entries.size() != this.streamCodecs.size()) {
                throw new IllegalArgumentException("Stream codec count does not match entry count in RecordValueMapper. This is a bug in LibX.");
            }
        }

        @Nonnull
        public T decode(@Nonnull FriendlyByteBuf buffer) {
            RecordComponent[] parts = RecordValueMapper.this.cls.getRecordComponents();
            Object[] values = new Object[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                values[i] = this.streamCodecs.get(i).decode((Object)buffer);
            }
            try {
                return (Record)RecordValueMapper.this.ctor.newInstance(values);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Failed to create record for config.", e);
            }
        }

        public void encode(@Nonnull FriendlyByteBuf buffer, @Nonnull T value) {
            RecordComponent[] parts = RecordValueMapper.this.cls.getRecordComponents();
            for (int i = 0; i < parts.length; ++i) {
                try {
                    this.streamCodecs.get(i).encode((Object)buffer, RecordValueMapper.accessComponent(parts[i], value));
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Failed to get record value for config.", e);
                }
            }
        }

        public String toString() {
            return "RecordStreamCodec[" + RecordValueMapper.this.cls.getName() + "]";
        }
    }
}

