/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.mappers.special;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.moddingx.libx.config.correct.ConfigCorrection;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;

public class EnumValueMapper<T extends Enum<T>>
implements ValueMapper<T, JsonPrimitive> {
    private static final Map<Class<? extends Enum<?>>, EnumValueMapper<?>> mappers = new HashMap();
    private final Class<T> cls;

    public static <T extends Enum<T>> EnumValueMapper<T> getMapper(Class<T> enumClass) {
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("Can't get enum serializer for non-enum class: " + String.valueOf(enumClass));
        }
        if (((Enum[])enumClass.getEnumConstants()).length == 0) {
            throw new IllegalArgumentException("Can't get enum serializer for empty enum: " + String.valueOf(enumClass));
        }
        if (mappers.containsKey(enumClass)) {
            return mappers.get(enumClass);
        }
        EnumValueMapper<T> mapper = new EnumValueMapper<T>(enumClass);
        mappers.put(enumClass, mapper);
        return mapper;
    }

    public EnumValueMapper(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public Class<T> type() {
        return this.cls;
    }

    @Override
    public Class<JsonPrimitive> element() {
        return JsonPrimitive.class;
    }

    @Override
    public T fromJson(JsonPrimitive json) {
        Enum[] enums;
        String str = json.getAsString().toLowerCase(Locale.ROOT).strip();
        for (Enum e : enums = (Enum[])this.cls.getEnumConstants()) {
            if (!e.name().toLowerCase(Locale.ROOT).equals(str)) continue;
            return (T)e;
        }
        throw new NoSuchElementException("Enum constant not found: " + str);
    }

    @Override
    public JsonPrimitive toJson(T value) {
        return new JsonPrimitive(((Enum)value).name().toLowerCase(Locale.ROOT));
    }

    @Override
    public StreamCodec<? super FriendlyByteBuf, T> streamCodec() {
        return NeoForgeStreamCodecs.enumCodec(this.cls);
    }

    @Override
    public Optional<T> correct(JsonElement json, ConfigCorrection<T> correction) {
        if (json.isJsonPrimitive() || json.isJsonNull()) {
            Enum[] enums;
            String str = json.isJsonNull() ? "null" : json.getAsString().toLowerCase(Locale.ROOT).strip();
            for (Enum e : enums = (Enum[])this.cls.getEnumConstants()) {
                if (!e.name().toLowerCase(Locale.ROOT).equals(str) && !str.startsWith(e.name()) && !str.endsWith(e.name())) continue;
                return Optional.of(e);
            }
            try {
                int ordinal = Integer.parseInt(str);
                if (ordinal >= 0 && ordinal < enums.length) {
                    return Optional.of(enums[ordinal]);
                }
                return Optional.empty();
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    public List<String> comment() {
        return List.of("Allowed values: " + Arrays.stream((Enum[])this.cls.getEnumConstants()).map(e -> e.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", ")));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<T> createEditor(ValidatorInfo<?> validator) {
        return ConfigEditor.toggle(ImmutableList.copyOf((Object[])((Enum[])this.cls.getEnumConstants())), e -> Component.literal((String)e.name().toLowerCase(Locale.ROOT)));
    }
}

