/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.screen.content.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.ConfigScreenContent;
import org.moddingx.libx.config.gui.EditorOps;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.impl.config.gui.EditorHelper;
import org.moddingx.libx.impl.config.gui.screen.content.CollectionContent;
import org.moddingx.libx.impl.config.gui.screen.content.component.ComponentType;
import org.moddingx.libx.impl.config.gui.screen.content.component.PreviewWidget;
import org.moddingx.libx.impl.config.gui.screen.content.component.type.KeybindComponentType;
import org.moddingx.libx.impl.config.gui.screen.content.component.type.TextComponentType;
import org.moddingx.libx.impl.config.gui.screen.content.component.type.TranslationComponentType;
import org.moddingx.libx.impl.config.gui.screen.widget.TextWidget;
import org.moddingx.libx.screen.ColorPicker;
import org.moddingx.libx.util.lazy.CachedValue;

public class ComponentContent
implements ConfigScreenContent<Component> {
    @Nullable
    private final Component nonEditable;
    private Consumer<Component> inputChanged;
    private final Map<ComponentType, MutableComponent> typeMap;
    private ComponentType currentType;
    private MutableComponent base;
    private StyleSetting bold;
    private StyleSetting italic;
    private StyleSetting underlined;
    private StyleSetting strikethrough;
    private StyleSetting obfuscated;
    private boolean hasColor;
    private TextColor color;
    private List<Component> siblings;
    private final CachedValue<Component> result;
    private final ConfigEditor<ComponentType> typeEditor;
    private final ConfigEditor<StyleSetting> boldEditor;
    private final ConfigEditor<StyleSetting> italicEditor;
    private final ConfigEditor<StyleSetting> underlinedEditor;
    private final ConfigEditor<StyleSetting> strikethroughEditor;
    private final ConfigEditor<StyleSetting> obfuscatedEditor;
    private final ConfigEditor<List<Component>> siblingEditor;
    private TextWidget previewWidget;
    private AbstractWidget typeWidget;
    private AbstractWidget boldWidget;
    private AbstractWidget italicWidget;
    private AbstractWidget underlinedWidget;
    private AbstractWidget strikethroughWidget;
    private AbstractWidget obfuscatedWidget;
    private ColorPicker colorWidget;
    private AbstractWidget siblingWidget;

    public ComponentContent(@Nonnull Component value) {
        List<KeybindComponentType> types = List.of(new TextComponentType(), new TranslationComponentType(), new KeybindComponentType());
        this.typeMap = new HashMap<ComponentType, MutableComponent>();
        ComponentType type = null;
        MutableComponent cmp = null;
        for (ComponentType componentType : types) {
            if (cmp == null) {
                cmp = componentType.init(value, c -> {
                    this.typeMap.put(t, (MutableComponent)c);
                    if (this.currentType == t) {
                        this.base = c;
                        this.update();
                    }
                });
                if (cmp == null) continue;
                type = componentType;
                continue;
            }
            componentType.init(value, c -> {
                this.typeMap.put(t, (MutableComponent)c);
                if (this.currentType == t) {
                    this.base = c;
                    this.update();
                }
            });
        }
        if (type == null) {
            this.nonEditable = value;
        } else {
            this.nonEditable = null;
            this.currentType = type;
            this.typeMap.put(type, cmp);
            this.base = cmp;
            Style style = value.getStyle();
            this.bold = StyleSetting.get(style.bold);
            this.italic = StyleSetting.get(style.italic);
            this.underlined = StyleSetting.get(style.underlined);
            this.strikethrough = StyleSetting.get(style.strikethrough);
            this.obfuscated = StyleSetting.get(style.obfuscated);
            this.hasColor = style.getColor() != null;
            this.color = style.getColor() == null ? TextColor.fromRgb((int)0xFFFFFF) : style.getColor();
            this.siblings = value.getSiblings();
        }
        this.typeEditor = ConfigEditor.toggle(types, ComponentType::name);
        this.boldEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> Component.translatable((String)"libx.config.gui.component.bold", (Object[])new Object[]{Component.translatable((String)("libx.config.gui.component.style_setting." + s.value))}));
        this.italicEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> Component.translatable((String)"libx.config.gui.component.italic", (Object[])new Object[]{Component.translatable((String)("libx.config.gui.component.style_setting." + s.value))}));
        this.underlinedEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> Component.translatable((String)"libx.config.gui.component.underlined", (Object[])new Object[]{Component.translatable((String)("libx.config.gui.component.style_setting." + s.value))}));
        this.strikethroughEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> Component.translatable((String)"libx.config.gui.component.strikethrough", (Object[])new Object[]{Component.translatable((String)("libx.config.gui.component.style_setting." + s.value))}));
        this.obfuscatedEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> Component.translatable((String)"libx.config.gui.component.obfuscated", (Object[])new Object[]{Component.translatable((String)("libx.config.gui.component.style_setting." + s.value))}));
        this.siblingEditor = ConfigEditor.custom(List.of(), l -> new CollectionContent<Component, List<Component>>(this, l, ConfigEditor.custom(Component.empty(), ComponentContent::new), Function.identity(), true){

            @Override
            public Component message() {
                return Component.translatable((String)"libx.config.gui.component.siblings");
            }
        });
        this.result = new CachedValue<Component>(() -> {
            if (this.nonEditable != null) {
                return this.nonEditable;
            }
            MutableComponent tc = this.base.copy();
            Style style = Style.EMPTY.withBold(this.bold.value).withItalic(this.italic.value).withUnderlined(this.underlined.value).withStrikethrough(this.strikethrough.value).withObfuscated(this.obfuscated.value);
            if (this.hasColor) {
                style = style.withColor(this.color);
            }
            tc.setStyle(style);
            this.siblings.forEach(arg_0 -> ((MutableComponent)tc).append(arg_0));
            this.inputChanged.accept((Component)tc);
            return tc;
        });
    }

    @Override
    public Component title() {
        return Component.translatable((String)"libx.config.gui.component.title");
    }

    @Override
    public Component message() {
        return this.result.get();
    }

    @Override
    public boolean searchable() {
        return false;
    }

    @Override
    public void init(Consumer<Component> inputChanged) {
        this.inputChanged = inputChanged;
    }

    private void update() {
        this.result.invalidate();
        if (this.previewWidget != null) {
            this.previewWidget.setMessage(this.result.get());
        }
        if (this.inputChanged != null) {
            this.inputChanged.accept(this.result.get());
        }
    }

    @Override
    public void buildGui(Screen screen, ConfigScreenContent.ScreenManager manager, String search, Consumer<AbstractWidget> consumer) {
        int y = 0;
        this.previewWidget = new PreviewWidget(20, y, manager.contentWidth() - 40, 36, this.result.get());
        consumer.accept(this.previewWidget);
        y += 44;
        if (this.nonEditable != null) {
            consumer.accept(new TextWidget(20, y, manager.contentWidth() - 40, 18, (Component)Component.translatable((String)"libx.config.gui.component.no_edit"), List.of()));
            return;
        }
        WidgetProperties<ComponentType> typeProperties = new WidgetProperties<ComponentType>(5, y, 180, 20, type -> {
            this.currentType = type;
            this.base = this.typeMap.getOrDefault(type, type.defaultValue());
            this.update();
            manager.rebuild();
        });
        this.typeWidget = EditorHelper.create(screen, this.typeEditor, this.currentType, this.typeWidget, typeProperties);
        consumer.accept(this.typeWidget);
        AtomicInteger atomicY = new AtomicInteger(y += 27);
        this.currentType.buildGui(screen, manager, atomicY, consumer);
        y = atomicY.get();
        int width = Math.min(180, (manager.contentWidth() - 10) / 3);
        WidgetProperties<StyleSetting> boldProperties = new WidgetProperties<StyleSetting>(5, y += 8, width, 20, bold -> {
            this.bold = bold;
            this.update();
        });
        this.boldWidget = EditorHelper.create(screen, this.boldEditor, this.bold, this.boldWidget, boldProperties);
        consumer.accept(this.boldWidget);
        WidgetProperties<StyleSetting> italicProperties = new WidgetProperties<StyleSetting>(10 + width, y, width, 20, italic -> {
            this.italic = italic;
            this.update();
        });
        this.italicWidget = EditorHelper.create(screen, this.italicEditor, this.italic, this.italicWidget, italicProperties);
        consumer.accept(this.italicWidget);
        WidgetProperties<StyleSetting> underlinedProperties = new WidgetProperties<StyleSetting>(15 + 2 * width, y, width, 20, underlined -> {
            this.underlined = underlined;
            this.update();
        });
        this.underlinedWidget = EditorHelper.create(screen, this.underlinedEditor, this.underlined, this.underlinedWidget, underlinedProperties);
        consumer.accept(this.underlinedWidget);
        WidgetProperties<StyleSetting> strikethroughProperties = new WidgetProperties<StyleSetting>(5, y += 23, width, 20, strikethrough -> {
            this.strikethrough = strikethrough;
            this.update();
        });
        this.strikethroughWidget = EditorHelper.create(screen, this.strikethroughEditor, this.strikethrough, this.strikethroughWidget, strikethroughProperties);
        consumer.accept(this.strikethroughWidget);
        WidgetProperties<StyleSetting> obfuscatedProperties = new WidgetProperties<StyleSetting>(10 + width, y, width, 20, obfuscated -> {
            this.obfuscated = obfuscated;
            this.update();
        });
        this.obfuscatedWidget = EditorHelper.create(screen, this.obfuscatedEditor, this.obfuscated, this.obfuscatedWidget, obfuscatedProperties);
        consumer.accept(this.obfuscatedWidget);
        Checkbox hasColorWidget = Checkbox.builder((Component)Component.empty(), (Font)screen.getMinecraft().font).pos(14, (y += 25) + 40).maxWidth(20).selected(this.hasColor).onValueChange((checkbox, value) -> {
            this.hasColor = value;
            EditorOps.wrap((GuiEventListener)this.colorWidget).enabled(this.hasColor);
            this.update();
        }).build();
        consumer.accept((AbstractWidget)hasColorWidget);
        this.colorWidget = new ColorPicker(37, y, this.colorWidget);
        this.colorWidget.setColor(this.color);
        this.colorWidget.setResponder(color -> {
            this.color = color;
            this.update();
        });
        EditorOps.wrap((GuiEventListener)this.colorWidget).enabled(this.hasColor);
        consumer.accept(this.colorWidget);
        WidgetProperties<List> siblingProperties = new WidgetProperties<List>(5, y += 105, 180, 20, siblings -> {
            this.siblings = siblings;
            this.update();
        });
        this.siblingWidget = EditorHelper.create(screen, this.siblingEditor, this.siblings, this.siblingWidget, siblingProperties);
        consumer.accept(this.siblingWidget);
    }

    private static enum StyleSetting {
        INHERIT(null),
        TRUE(true),
        FALSE(false);

        @Nullable
        public final Boolean value;

        private StyleSetting(Boolean value) {
            this.value = value;
        }

        public static StyleSetting get(@Nullable Boolean value) {
            if (value == null) {
                return INHERIT;
            }
            return value != false ? TRUE : FALSE;
        }
    }
}

