/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.moddingx.libx.impl.config.ConfigImpl;
import org.moddingx.libx.impl.config.gui.ConfigDisplay;
import org.moddingx.libx.impl.config.gui.screen.ConfigScreenManager;
import org.moddingx.libx.impl.config.gui.screen.ConfigSelectScreen;
import org.moddingx.libx.impl.config.gui.screen.RootConfigScreen;

public class ModConfigGuiAdapter {
    private final String modid;
    private final ModContainer context;
    private boolean hasRegisteredExt;

    public ModConfigGuiAdapter(String modid, ModContainer context) {
        this.modid = modid;
        this.context = context;
        this.checkRegister();
    }

    public synchronized void checkRegister() {
        if (!this.hasRegisteredExt && ConfigImpl.getAllConfigs().stream().anyMatch(config -> this.modid.equals(config.id.getNamespace()))) {
            this.hasRegisteredExt = true;
            this.context.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)this::createScreen));
        }
    }

    public Screen createScreen(ModContainer modContainer, Screen modListScreen) {
        List<ConfigImpl> configs = ConfigImpl.getAllConfigs().stream().filter(config -> this.modid.equals(config.id.getNamespace())).sorted(Comparator.comparing(config -> "config".equals(config.id.getPath()) ? "" : config.id.getPath())).toList();
        if (configs.isEmpty()) {
            return modListScreen;
        }
        if (configs.size() == 1) {
            return this.factory(modListScreen.getMinecraft(), modListScreen).apply(configs.get(0));
        }
        return new ConfigSelectScreen(this.factory(modListScreen.getMinecraft(), modListScreen), configs, modListScreen);
    }

    private Function<ConfigImpl, Screen> factory(Minecraft minecraft, @Nullable Screen root) {
        return config -> {
            ConfigDisplay display = config.createDisplay();
            ConfigScreenManager manager = new ConfigScreenManager(minecraft, root, display);
            RootConfigScreen screen = new RootConfigScreen(manager, (ConfigImpl)config);
            manager.pushUnchecked(screen);
            return screen;
        };
    }
}

