/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.moddingx.libx.impl.datapack.LibXPack;

public class DatapackHelper {
    public static final Gson GSON = (Gson)Util.make(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        return builder.create();
    });

    public static String registryPath(ResourceKey<?> key) {
        Object registryPart = key.registry().getNamespace().equals("minecraft") ? key.registry().getPath() : key.registry().getNamespace() + "/" + key.registry().getPath();
        return key.location().getNamespace() + "/" + (String)registryPart + "/" + key.location().getPath() + ".json";
    }

    public static IoSupplier<InputStream> generatePackMeta(String description, PackType packType) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bout, StandardCharsets.UTF_8);
            JsonObject packFile = new JsonObject();
            JsonObject packSection = new JsonObject();
            packSection.addProperty("description", description);
            packSection.addProperty("pack_format", (Number)LibXPack.PACK_CONFIG.get(packType).version());
            packFile.add("pack", (JsonElement)packSection);
            writer.write(GSON.toJson((JsonElement)packFile) + "\n");
            ((Writer)writer).close();
            bout.close();
            byte[] data = bout.toByteArray();
            return () -> new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create dynamic pack.mcmeta", e);
        }
    }
}

