/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.texture;

import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.datagen.provider.texture.Textures;
import org.moddingx.libx.mod.ModX;

public class TextureBuilder {
    private final ModX mod;
    private final Function<ResourceLocation, BufferedImage> textureLoader;
    private int scale;
    private final Map<ResourceLocation, Pair<BufferedImage, Integer>> images;
    private final Map<ResourceLocation, Pair<BufferedImage, Integer>> fakes;

    public TextureBuilder(ModX mod, Function<ResourceLocation, BufferedImage> textureLoader) {
        this.mod = mod;
        this.textureLoader = textureLoader;
        this.scale = 1;
        this.images = new HashMap<ResourceLocation, Pair<BufferedImage, Integer>>();
        this.fakes = new HashMap<ResourceLocation, Pair<BufferedImage, Integer>>();
    }

    public TextureBuilder addTexture(String loc, int defaultSize) {
        return this.addTexture(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addImage(String loc, int defaultSize) {
        return this.addImage(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addTexture(ResourceLocation loc, int defaultSize) {
        return this.addTexture(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addImage(ResourceLocation loc, int defaultSize) {
        return this.addImage(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addTexture(String loc, int defaultWidth, int defaultHeight) {
        return this.addTexture(this.mod.resource(loc), defaultWidth, defaultHeight);
    }

    public TextureBuilder addImage(String loc, int defaultWidth, int defaultHeight) {
        return this.addImage(this.mod.resource(loc), defaultWidth, defaultHeight);
    }

    public TextureBuilder addTexture(ResourceLocation loc, int defaultWidth, int defaultHeight) {
        return this.addImage(ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("textures/" + loc.getPath() + ".png")), defaultWidth, defaultHeight);
    }

    public TextureBuilder addFake(ResourceLocation loc, BufferedImage image) {
        return this.addFake(loc, image, 1);
    }

    public TextureBuilder addFake(ResourceLocation loc, BufferedImage image, int scale) {
        if (this.fakes.containsKey(loc)) {
            throw new IllegalStateException("Duplicate fake texture: " + String.valueOf(loc));
        }
        this.fakes.put(loc, (Pair<BufferedImage, Integer>)Pair.of((Object)image, (Object)scale));
        return this;
    }

    public TextureBuilder addFakeTexture(ResourceLocation loc, ResourceLocation texLoc, UnaryOperator<BufferedImage> image) {
        return this.addFakeImage(loc, ResourceLocation.fromNamespaceAndPath((String)texLoc.getNamespace(), (String)("textures/" + texLoc.getPath() + ".png")), image);
    }

    public TextureBuilder addFakeImage(ResourceLocation loc, ResourceLocation imgLoc, UnaryOperator<BufferedImage> image) {
        if (!this.images.containsKey(imgLoc)) {
            throw new IllegalStateException("Can't add fake transform of non-loaded image: " + String.valueOf(imgLoc));
        }
        if (this.fakes.containsKey(loc)) {
            throw new IllegalStateException("Duplicate fake texture: " + String.valueOf(loc));
        }
        Pair<BufferedImage, Integer> original = this.images.get(imgLoc);
        this.fakes.put(loc, (Pair<BufferedImage, Integer>)Pair.of((Object)((BufferedImage)image.apply((BufferedImage)original.getLeft())), (Object)((Integer)original.getRight())));
        return this;
    }

    public TextureBuilder addImage(ResourceLocation loc, int defaultWidth, int defaultHeight) {
        if (!TextureBuilder.isPowerOfTwo(defaultWidth)) {
            throw new IllegalArgumentException("Invalid default width for texture " + String.valueOf(loc) + ": " + defaultWidth + " is not a power of two.");
        }
        if (!TextureBuilder.isPowerOfTwo(defaultHeight)) {
            throw new IllegalArgumentException("Invalid default height for texture " + String.valueOf(loc) + ": " + defaultHeight + " is not a power of two.");
        }
        if (!this.images.containsKey(loc)) {
            int imageScaleByHeight;
            BufferedImage image = this.textureLoader.apply(loc);
            if (!TextureBuilder.isPowerOfTwo(image.getWidth())) {
                throw new IllegalStateException("Invalid texture width for texture " + String.valueOf(loc) + ": " + image.getWidth() + " is not a power of two.");
            }
            if (!TextureBuilder.isPowerOfTwo(image.getHeight())) {
                throw new IllegalStateException("Invalid texture height for texture " + String.valueOf(loc) + ": " + image.getHeight() + " is not a power of two.");
            }
            if (image.getWidth() < defaultWidth || image.getHeight() < defaultHeight) {
                throw new IllegalStateException("Invalid texture: " + String.valueOf(loc) + ": Image is smaller than default");
            }
            int imageScaleByWidth = image.getWidth() / defaultWidth;
            if (imageScaleByWidth != (imageScaleByHeight = image.getHeight() / defaultHeight)) {
                int gcd = BigInteger.valueOf(defaultWidth).gcd(BigInteger.valueOf(defaultHeight)).intValue();
                throw new IllegalStateException("Texture " + String.valueOf(loc) + " has invalid aspect ratio, expected " + defaultWidth / gcd + ":" + defaultHeight / gcd);
            }
            this.images.put(loc, (Pair<BufferedImage, Integer>)Pair.of((Object)image, (Object)imageScaleByWidth));
            this.scale = TextureBuilder.lcm(this.scale, imageScaleByWidth);
        }
        return this;
    }

    public Textures build() {
        HashMap<ResourceLocation, Pair<BufferedImage, Integer>> allImages = new HashMap<ResourceLocation, Pair<BufferedImage, Integer>>(this.images);
        allImages.putAll(this.fakes);
        return new Textures(this.mod, this.textureLoader, this.scale, allImages);
    }

    private static boolean isPowerOfTwo(int number) {
        return number > 0 && (number & number - 1) == 0;
    }

    private static int gcd(int a, int b) {
        return BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).intValue();
    }

    private static int lcm(int a, int b) {
        return a * b / TextureBuilder.gcd(a, b);
    }
}

