/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.tags;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.impl.datagen.tags.DecorationTags;
import org.moddingx.libx.impl.tags.InternalTagProvider;
import org.moddingx.libx.impl.tags.InternalTags;
import org.moddingx.libx.mod.ModX;

public abstract class CommonTagsProviderBase
implements DataProvider {
    protected final ModX mod;
    private final BlockTagProviderBase blockTags;
    private final ItemTagProviderBase itemTags;
    private final FluidTagProviderBase fluidTags;
    private boolean isSetup = false;
    private final List<Runnable> itemCopies = new ArrayList<Runnable>();
    private final List<Pair<TagKey<Fluid>, TagKey<Block>>> fluidCopies = new ArrayList<Pair<TagKey<Fluid>, TagKey<Block>>>();
    private boolean hasLibXInternalTags = false;

    public CommonTagsProviderBase(DatagenContext ctx) {
        this.mod = ctx.mod();
        CompletableFuture<RegistryAccess> lookupProvider = CompletableFuture.completedFuture(ctx.registries().registryAccess());
        this.blockTags = new BlockTagProviderBase(ctx.output(), lookupProvider, ctx.mod().modid, ctx.fileHelper());
        this.itemTags = new ItemTagProviderBase(ctx.output(), lookupProvider, ctx.mod().modid, ctx.fileHelper(), this.blockTags);
        this.fluidTags = new FluidTagProviderBase(ctx.output(), lookupProvider, ctx.mod().modid, ctx.fileHelper());
        ctx.addAdditionalProvider(c -> this.blockTags);
        ctx.addAdditionalProvider(c -> this.itemTags);
        ctx.addAdditionalProvider(c -> this.fluidTags);
    }

    public abstract void setup();

    private void doSetup() {
        if (this.getClass() == InternalTagProvider.class) {
            this.initInternalTags();
        }
        this.setup();
        BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).location().getNamespace())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::location))).map(Map.Entry::getValue).forEach(block -> {
            DecorationTags.addTags(block, this, this::initInternalTags);
            this.defaultBlockTags((Block)block);
        });
        BuiltInRegistries.ITEM.entrySet().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).location().getNamespace())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::location))).map(Map.Entry::getValue).forEach(this::defaultItemTags);
        BuiltInRegistries.FLUID.entrySet().stream().filter(entry -> this.mod.modid.equals(((ResourceKey)entry.getKey()).location().getNamespace())).sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::location))).map(Map.Entry::getValue).forEach(this::defaultFluidTags);
    }

    public void defaultItemTags(Item item) {
    }

    public void defaultBlockTags(Block block) {
    }

    public void defaultFluidTags(Fluid fluid) {
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> item(TagKey<Item> tag) {
        return this.itemTags.tag(tag);
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> block(TagKey<Block> tag) {
        return this.blockTags.tag(tag);
    }

    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Fluid> fluid(TagKey<Fluid> tag) {
        return this.fluidTags.tag(tag);
    }

    public void copyBlock(TagKey<Block> from, TagKey<Item> to) {
        this.itemCopies.add(() -> this.itemTags.copy(from, to));
    }

    public void copyFluid(TagKey<Fluid> from, TagKey<Block> to) {
        this.fluidCopies.add((Pair<TagKey<Fluid>, TagKey<Block>>)Pair.of(from, to));
    }

    @Nonnull
    public final String getName() {
        return this.mod.modid + " common tags";
    }

    @Nonnull
    public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
        return CompletableFuture.completedFuture(null);
    }

    private void initInternalTags() {
        if (!this.hasLibXInternalTags) {
            this.hasLibXInternalTags = true;
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Items.getTags().entrySet()) {
                this.item(entry.getValue());
            }
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Blocks.getTags().entrySet()) {
                this.block(entry.getValue());
            }
            for (Map.Entry<TagKey<Item>, TagKey<Item>> entry : InternalTags.Items.getCopies().entrySet()) {
                this.copyBlock(entry.getKey(), entry.getValue());
            }
        }
    }

    private class BlockTagProviderBase
    extends BlockTagsProvider {
        private Map<ResourceLocation, TagBuilder> tagCache;

        protected BlockTagProviderBase(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper fileHelper) {
            super(packOutput, lookupProvider, modid, fileHelper);
        }

        protected void addTags(@Nonnull HolderLookup.Provider lookupProvider) {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.builders.putAll(this.tagCache);
            }
            for (Pair<TagKey<Fluid>, TagKey<Block>> copy : CommonTagsProviderBase.this.fluidCopies) {
                IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> builder = this.tag((TagKey<Block>)((TagKey)copy.getRight()));
                for (ResourceLocation entry : CommonTagsProviderBase.this.fluidTags.getTagInfo((TagKey<Fluid>)((TagKey)copy.getLeft()))) {
                    BuiltInRegistries.FLUID.getOptional(entry).ifPresent(fluid -> builder.add((Object)fluid.defaultFluidState().createLegacyBlock().getBlock()));
                }
            }
        }

        @Nonnull
        public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
            this.tagCache = new HashMap<ResourceLocation, TagBuilder>(this.builders);
            return super.run(cache);
        }

        @Nonnull
        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> tag(@Nonnull TagKey<Block> tag) {
            return super.tag(tag);
        }

        @Nonnull
        public String getName() {
            return CommonTagsProviderBase.this.mod.modid + " common block tags";
        }
    }

    private class ItemTagProviderBase
    extends ItemTagsProvider {
        private Map<ResourceLocation, TagBuilder> tagCache;

        protected ItemTagProviderBase(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper fileHelper, BlockTagProviderBase blockTags) {
            super(packOutput, lookupProvider, blockTags.contentsGetter(), modid, fileHelper);
        }

        protected void addTags(@Nonnull HolderLookup.Provider lookupProvider) {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.builders.putAll(this.tagCache);
            }
            for (Runnable copy : CommonTagsProviderBase.this.itemCopies) {
                copy.run();
            }
        }

        @Nonnull
        public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
            this.tagCache = new HashMap<ResourceLocation, TagBuilder>(this.builders);
            return super.run(cache);
        }

        @Nonnull
        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag(@Nonnull TagKey<Item> tag) {
            return super.tag(tag);
        }

        public void copy(@Nonnull TagKey<Block> blockTag, @Nonnull TagKey<Item> itemTag) {
            super.copy(blockTag, itemTag);
        }

        @Nonnull
        public String getName() {
            return CommonTagsProviderBase.this.mod.modid + " common item tags";
        }
    }

    private class FluidTagProviderBase
    extends FluidTagsProvider {
        private Map<ResourceLocation, TagBuilder> tagCache;

        protected FluidTagProviderBase(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, String modid, ExistingFileHelper fileHelper) {
            super(packOutput, lookupProvider, modid, fileHelper);
        }

        protected void addTags(@Nonnull HolderLookup.Provider lookupProvider) {
            if (!CommonTagsProviderBase.this.isSetup) {
                CommonTagsProviderBase.this.isSetup = true;
                CommonTagsProviderBase.this.doSetup();
            } else if (this.tagCache != null) {
                this.builders.putAll(this.tagCache);
            }
        }

        @Nonnull
        public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
            this.tagCache = new HashMap<ResourceLocation, TagBuilder>(this.builders);
            return super.run(cache);
        }

        @Nonnull
        public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Fluid> tag(@Nonnull TagKey<Fluid> tag) {
            return super.tag(tag);
        }

        public List<ResourceLocation> getTagInfo(TagKey<Fluid> tag) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender<Fluid> builder = this.tag(tag);
            return builder.getInternalBuilder().entries.stream().filter(p -> !p.tag).map(TagEntry::getId).toList();
        }

        @Nonnull
        public String getName() {
            return CommonTagsProviderBase.this.mod.modid + " common fluid tags";
        }
    }
}

