/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.recipe;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;
import org.moddingx.libx.mod.ModX;

public abstract class RecipeProviderBase
extends RecipeProvider
implements RecipeExtension {
    protected final ModX mod;
    private RecipeOutput output;

    public RecipeProviderBase(DatagenContext ctx) {
        super(ctx.output(), CompletableFuture.completedFuture(ctx.registries().registryAccess()));
        this.mod = ctx.mod();
    }

    @Nonnull
    public final String getName() {
        return this.mod.modid + " recipes";
    }

    protected abstract void setup();

    protected List<ICondition> conditions() {
        return List.of();
    }

    protected final void buildRecipes(@Nonnull RecipeOutput output) {
        this.output = output.withConditions((ICondition[])this.conditions().toArray(ICondition[]::new));
        this.setupExtensions();
        this.setup();
    }

    private void setupExtensions() {
        HashSet collectedClasses = new HashSet();
        ArrayList<Method> extensionMethods = new ArrayList<Method>();
        for (Class<?> currentClass = this.getClass(); currentClass != null && currentClass != RecipeProviderBase.class && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Class<?> iface : currentClass.getInterfaces()) {
                if (!RecipeExtension.class.isAssignableFrom(iface) || !collectedClasses.add(iface)) continue;
                try {
                    Method method = iface.getMethod("setup", ModX.class, iface);
                    if (!Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Recipe extension setup method must be static: " + iface.getName() + "#setup");
                    }
                    extensionMethods.add(method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        for (Method method : extensionMethods) {
            try {
                method.invoke(null, this.mod, this);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can't access recipe extension setup method: " + method.getDeclaringClass().getName() + "#setup", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to run recipe extension setup: " + method.getDeclaringClass().getName(), e.getTargetException());
            }
        }
    }

    public ResourceLocation loc(ItemLike item) {
        return ResourceLocation.fromNamespaceAndPath((String)this.mod.modid, (String)Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem())).getPath());
    }

    public ResourceLocation loc(ItemLike item, String suffix) {
        return ResourceLocation.fromNamespaceAndPath((String)this.mod.modid, (String)(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem())).getPath() + "_" + suffix));
    }

    @Override
    public RecipeProviderBase provider() {
        return this;
    }

    @Override
    public RecipeOutput output() {
        return Objects.requireNonNull(this.output, "Recipe output not yet available.");
    }

    @Override
    public Criterion<?> criterion(ItemLike item) {
        return RecipeProviderBase.has((ItemLike)item);
    }

    @Override
    public Criterion<?> criterion(TagKey<Item> item) {
        return RecipeProviderBase.has(item);
    }

    @Override
    public Criterion<?> criterion(ItemPredicate ... items) {
        return RecipeProviderBase.inventoryTrigger((ItemPredicate[])items);
    }
}

