/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import org.moddingx.libx.datagen.provider.recipe.RecipeProviderBase;

public interface RecipeExtension {
    public RecipeProviderBase provider();

    public RecipeOutput output();

    public Criterion<?> criterion(ItemLike var1);

    public Criterion<?> criterion(TagKey<Item> var1);

    public Criterion<?> criterion(ItemPredicate ... var1);

    default public List<Criterion<?>> criteria(Ingredient item) {
        ArrayList instances = new ArrayList();
        if (item.isSimple()) {
            for (Ingredient.Value entry : item.getValues()) {
                if (entry instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue value = (Ingredient.ItemValue)entry;
                    instances.add(this.criterion(ItemPredicate.Builder.item().of(new ItemLike[]{value.item().getItem()}).build()));
                    continue;
                }
                if (!(entry instanceof Ingredient.TagValue)) continue;
                Ingredient.TagValue value = (Ingredient.TagValue)entry;
                instances.add(this.criterion(ItemPredicate.Builder.item().of(value.tag()).build()));
            }
        } else {
            ItemStack[] itemStackArray = item.getCustomIngredient();
            if (itemStackArray instanceof CompoundIngredient) {
                CompoundIngredient cmp = (CompoundIngredient)itemStackArray;
                for (Ingredient i : cmp.children()) {
                    instances.addAll(this.criteria(i));
                }
            } else {
                for (ItemStack stack : item.getItems()) {
                    instances.add(this.criterion(ItemPredicate.Builder.item().of(new ItemLike[]{stack.getItem()}).build()));
                }
            }
        }
        return instances;
    }
}

