/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.patchouli.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.StringSplitter;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.moddingx.libx.impl.datagen.load.DatagenFontLoader;

public class PageJson {
    public static JsonElement stack(ItemStack stack) {
        StringBuilder sb = new StringBuilder();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        sb.append(id.getNamespace());
        sb.append(":");
        sb.append(id.getPath());
        sb.append(PageJson.componentPatch(stack.getComponentsPatch()));
        if (stack.getCount() != 1) {
            sb.append("#");
            sb.append(stack.getCount());
        }
        return new JsonPrimitive(sb.toString());
    }

    private static String componentPatch(DataComponentPatch patch) {
        boolean empty = true;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry entry : patch.entrySet()) {
            Codec codec = ((DataComponentType)entry.getKey()).codec();
            if (codec == null) continue;
            if (empty) {
                empty = false;
                sb.append(",");
            }
            if (((Optional)entry.getValue()).isPresent()) {
                Tag tag = (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, ((Optional)entry.getValue()).get()).getOrThrow();
                sb.append(Objects.requireNonNull(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getKey())))).append("=").append(tag);
                continue;
            }
            sb.append("!").append(Objects.requireNonNull(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getKey()))));
        }
        sb.append("]");
        return empty ? "" : sb.toString();
    }

    public static List<String> splitText(String text) {
        return PageJson.splitText(text, false);
    }

    public static List<String> splitText(String text, boolean withInit) {
        return PageJson.splitText(text, withInit ? 14 : 16, 16);
    }

    public static List<String> splitText(String text, int skip) {
        return PageJson.splitText(text, Math.max(16 - skip, 1), 16);
    }

    public static List<String> splitText(String text, int linesHead, int linesTail) {
        Component displayText = PageJson.displayText(text);
        StringSplitter splitter = DatagenFontLoader.getFontMetrics(null);
        List<String> lines = splitter.splitLines((FormattedText)displayText, Math.round(191.4f), Style.EMPTY).stream().map(FormattedText::getString).map(String::strip).filter(s -> !s.isEmpty()).toList();
        ArrayList<String> pages = new ArrayList<String>();
        boolean first = true;
        while (!lines.isEmpty()) {
            pages.add(lines.stream().limit(first ? (long)linesHead : (long)linesTail).collect(Collectors.joining(" ")));
            lines = lines.stream().skip(first ? (long)linesHead : (long)linesTail).toList();
            first = false;
        }
        return List.copyOf(pages);
    }

    private static Component displayText(String text) {
        Style zeroWidth = Style.EMPTY.withFont(DatagenFontLoader.ZERO_WIDTH_FONT);
        MutableComponent display = Component.empty();
        StringBuilder current = new StringBuilder();
        StringBuilder currentFmt = new StringBuilder();
        int idx = 0;
        while (idx < text.length()) {
            if (text.charAt(idx) == '$' && idx + 1 < text.length() && text.charAt(idx + 1) == '(') {
                if (!current.isEmpty()) {
                    display.append((Component)Component.literal((String)current.toString()).setStyle(Style.EMPTY));
                    current = new StringBuilder();
                }
                int openCodes = 1;
                currentFmt.append("$(");
                idx += 2;
                while (openCodes > 0 && idx < text.length()) {
                    if (text.charAt(idx) == '$' && idx + 1 < text.length() && text.charAt(idx + 1) == '(') {
                        currentFmt.append("$(");
                        ++openCodes;
                        idx += 2;
                        continue;
                    }
                    if (text.charAt(idx) == ')') {
                        currentFmt.append(")");
                        --openCodes;
                        ++idx;
                        continue;
                    }
                    currentFmt.append(text.charAt(idx));
                    ++idx;
                }
                continue;
            }
            if (!currentFmt.isEmpty()) {
                display.append((Component)Component.literal((String)currentFmt.toString()).setStyle(zeroWidth));
                currentFmt = new StringBuilder();
            }
            current.append(text.charAt(idx));
            ++idx;
        }
        if (!current.isEmpty()) {
            display.append((Component)Component.literal((String)current.toString()).setStyle(Style.EMPTY));
        }
        if (!currentFmt.isEmpty()) {
            display.append((Component)Component.literal((String)currentFmt.toString()).setStyle(zeroWidth));
        }
        return display;
    }
}

