/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.ModelProvider;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedButton;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedDoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedFenceGateBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedHangingSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedPressurePlate;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSign;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedSlabBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedStairBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedTrapdoorBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWallBlock;
import org.moddingx.libx.impl.base.decoration.blocks.DecoratedWoodBlock;
import org.moddingx.libx.impl.datagen.model.TypedBlockModelProvider;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.util.lazy.LazyValue;

public abstract class BlockStateProviderBase
extends BlockStateProvider {
    public static final ResourceLocation LEAVES_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/leaves");
    public static final ResourceLocation BUTTON_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/button");
    public static final ResourceLocation PRESSED_BUTTON_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/button_pressed");
    public static final ResourceLocation PRESSURE_PLATE_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/pressure_plate_up");
    public static final ResourceLocation PRESSED_PRESSURE_PLATE_PARENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/pressure_plate_down");
    protected final ModX mod;
    protected final PackOutput packOutput;
    protected final ExistingFileHelper fileHelper;
    private final Set<Block> manualState = new HashSet<Block>();
    private final Set<Block> existingModel = new HashSet<Block>();
    private final Map<Block, ModelFile> customModel = new HashMap<Block, ModelFile>();
    @Nullable
    private ResourceLocation currentRenderTypes = null;
    private final Map<ResourceLocation, TypedBlockModelProvider> typedModelProviders = new HashMap<ResourceLocation, TypedBlockModelProvider>();

    public BlockStateProviderBase(DatagenContext ctx) {
        super(ctx.output(), ctx.mod().modid, ctx.fileHelper());
        this.mod = ctx.mod();
        this.packOutput = ctx.output();
        this.fileHelper = ctx.fileHelper();
    }

    @Nonnull
    public final String getName() {
        return this.mod.modid + " block states and models";
    }

    protected void manualState(Block b) {
        this.manualState.add(b);
    }

    protected void manualModel(Block b) {
        this.existingModel.add(b);
    }

    protected void manualModel(Block b, ModelFile model) {
        this.customModel.put(b, model);
    }

    @Nonnull
    public BlockModelProvider models() {
        return this.models(this.currentRenderTypes);
    }

    protected BlockModelProvider models(@Nullable ResourceLocation renderTypes) {
        if (renderTypes == null) {
            return super.models();
        }
        return this.typedModelProviders.computeIfAbsent(renderTypes, k -> new TypedBlockModelProvider(this.packOutput, this.mod.modid, this.fileHelper, renderTypes));
    }

    protected void setRenderType(@Nullable ResourceLocation renderTypes) {
        this.currentRenderTypes = renderTypes;
    }

    protected final void registerStatesAndModels() {
        this.setup();
        for (ResourceLocation id : BuiltInRegistries.BLOCK.keySet().stream().sorted().toList()) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(id);
            if (!this.mod.modid.equals(id.getNamespace()) || this.manualState.contains(block)) continue;
            if (this.existingModel.contains(block)) {
                this.defaultState(id, block, () -> this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath()))));
                continue;
            }
            if (this.customModel.containsKey(block)) {
                this.defaultState(id, block, () -> this.customModel.get(block));
                continue;
            }
            LazyValue<ModelFile> defaultModel = new LazyValue<ModelFile>(() -> this.defaultModel(id, block));
            this.defaultState(id, block, defaultModel::get);
        }
    }

    @Nonnull
    public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
        CompletableFuture mainFuture = super.run(cache);
        return CompletableFuture.allOf((CompletableFuture[])Stream.concat(Stream.of(mainFuture), this.typedModelProviders.values().stream().map(provider -> provider.generateAll(cache))).toArray(CompletableFuture[]::new));
    }

    protected abstract void setup();

    protected void defaultState(ResourceLocation id, Block block, Supplier<ModelFile> model) {
        if (block instanceof DecoratedWoodBlock) {
            ResourceLocation textureTop;
            ResourceLocation textureSide;
            DecoratedWoodBlock decorated = (DecoratedWoodBlock)block;
            if (decorated.log == null) {
                textureSide = BlockStateProviderBase.textureId(id);
                textureTop = BlockStateProviderBase.textureId(id, "top");
            } else if (decorated.parent.has(decorated.log)) {
                ResourceLocation logId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent.get(decorated.log)));
                textureSide = BlockStateProviderBase.textureId(logId);
                textureTop = BlockStateProviderBase.textureId(logId);
            } else {
                textureSide = BlockStateProviderBase.textureId(id);
                textureTop = BlockStateProviderBase.textureId(id);
            }
            this.axisBlock(decorated, textureSide, textureTop);
        } else if (block instanceof DecoratedSlabBlock) {
            DecoratedSlabBlock decorated = (DecoratedSlabBlock)block;
            this.slabBlock(decorated, BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))), BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))));
        } else if (block instanceof DecoratedStairBlock) {
            DecoratedStairBlock decorated = (DecoratedStairBlock)block;
            this.stairsBlock(decorated, BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))));
        } else if (block instanceof DecoratedWallBlock) {
            DecoratedWallBlock decorated = (DecoratedWallBlock)block;
            this.wallBlock(decorated, BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))));
        } else if (block instanceof DecoratedFenceBlock) {
            DecoratedFenceBlock decorated = (DecoratedFenceBlock)block;
            this.fenceBlock(decorated, BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))));
        } else if (block instanceof DecoratedFenceGateBlock) {
            DecoratedFenceGateBlock decorated = (DecoratedFenceGateBlock)block;
            this.fenceGateBlock(decorated, BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))));
        } else if (block instanceof DecoratedButton) {
            DecoratedButton decorated = (DecoratedButton)block;
            this.buttonBlock(decorated, BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))));
        } else if (block instanceof DecoratedPressurePlate) {
            DecoratedPressurePlate decorated = (DecoratedPressurePlate)block;
            this.pressurePlateBlock(decorated, BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent))));
        } else if (block instanceof DecoratedDoorBlock) {
            DecoratedDoorBlock decorated = (DecoratedDoorBlock)block;
            this.doorBlockWithRenderType(decorated, BlockStateProviderBase.textureId(id, "bottom"), BlockStateProviderBase.textureId(id, "top"), RenderTypes.CUTOUT);
        } else if (block instanceof DecoratedTrapdoorBlock) {
            DecoratedTrapdoorBlock decorated = (DecoratedTrapdoorBlock)block;
            this.trapdoorBlockWithRenderType(decorated, BlockStateProviderBase.textureId(id), true, RenderTypes.CUTOUT);
        } else if (block instanceof DecoratedSign.Standing) {
            DecoratedSign.Standing decorated = (DecoratedSign.Standing)block;
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder(id.getPath())).texture("particle", BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent)))))});
        } else if (block instanceof DecoratedSign.Wall) {
            DecoratedSign.Wall decorated = (DecoratedSign.Wall)block;
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder(id.getPath())).texture("particle", BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent)))))});
        } else if (block instanceof DecoratedHangingSign.Ceiling) {
            DecoratedHangingSign.Ceiling decorated = (DecoratedHangingSign.Ceiling)block;
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder(id.getPath())).texture("particle", BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent)))))});
        } else if (block instanceof DecoratedHangingSign.Wall) {
            DecoratedHangingSign.Wall decorated = (DecoratedHangingSign.Wall)block;
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().getBuilder(id.getPath())).texture("particle", BlockStateProviderBase.textureId(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)decorated.parent)))))});
        } else if (block.getStateDefinition().getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            for (Direction direction : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                builder.partialState().with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).addModels(new ConfiguredModel[]{new ConfiguredModel(model.get(), 0, (int)direction.getOpposite().toYRot(), false)});
            }
        } else if (block.getStateDefinition().getProperties().contains(BlockStateProperties.FACING)) {
            VariantBlockStateBuilder builder = this.getVariantBuilder(block);
            for (Direction direction : BlockStateProperties.FACING.getPossibleValues()) {
                builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).addModels(new ConfiguredModel[]{new ConfiguredModel(model.get(), direction == Direction.DOWN ? 180 : (direction.getAxis().isHorizontal() ? 90 : 0), direction.getAxis().isVertical() ? 0 : (int)direction.getOpposite().toYRot(), false)});
            }
        } else {
            this.simpleBlock(block, model.get());
        }
    }

    protected ModelFile defaultModel(ResourceLocation id, Block block) {
        if (block.getStateDefinition().getPossibleStates().stream().allMatch(state -> state.getRenderShape() != RenderShape.MODEL)) {
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                Optional<ResourceLocation> tex = Optional.ofNullable(this.fluidTextureId(liquidBlock.fluid.getSource().getFluidType()));
                return (ModelFile)tex.map(resourceLocation -> (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(id.getPath())).texture("particle", resourceLocation)).orElseGet(() -> (BlockModelBuilder)this.models().getBuilder(id.getPath()));
            }
            return this.models().getBuilder(id.getPath());
        }
        if (block instanceof LeavesBlock) {
            return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath(), LEAVES_PARENT)).texture("all", this.blockTexture(block))).renderType(RenderTypes.CUTOUT_MIPPED);
        }
        return this.cubeAll(block);
    }

    public void buttonBlock(Block block, ResourceLocation texture) {
        ResourceLocation blockId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block));
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(blockId.getPath(), BUTTON_PARENT)).texture("texture", texture);
        ModelBuilder pressedModel = ((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + "_pressed", PRESSED_BUTTON_PARENT)).texture("texture", texture);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (AttachFace face : BlockStateProperties.ATTACH_FACE.getPossibleValues()) {
            for (Direction direction : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                builder.partialState().with((Property)BlockStateProperties.ATTACH_FACE, (Comparable)face).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).with((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model, face.ordinal() * 90, (int)direction.getOpposite().toYRot(), false)});
                builder.partialState().with((Property)BlockStateProperties.ATTACH_FACE, (Comparable)face).with((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction).with((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressedModel, face.ordinal() * 90, (int)direction.getOpposite().toYRot(), false)});
            }
        }
    }

    public void pressurePlateBlock(Block block, ResourceLocation texture) {
        ResourceLocation blockId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block));
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(blockId.getPath(), PRESSURE_PLATE_PARENT)).texture("texture", texture);
        ModelBuilder pressedModel = ((BlockModelBuilder)this.models().withExistingParent(blockId.getPath() + "_down", PRESSED_PRESSURE_PLATE_PARENT)).texture("texture", texture);
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        builder.partialState().with((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        builder.partialState().with((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressedModel)});
    }

    private static ResourceLocation textureId(ResourceLocation blockId) {
        Objects.requireNonNull(blockId);
        return ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath()));
    }

    private static ResourceLocation textureId(ResourceLocation blockId, String suffix) {
        Objects.requireNonNull(blockId);
        return ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)("block/" + blockId.getPath() + "_" + suffix));
    }

    @Nullable
    protected ResourceLocation fluidTextureId(FluidType fluidType) {
        ResourceLocation id = NeoForgeRegistries.FLUID_TYPES.getKey((Object)fluidType);
        if (id == null) {
            throw new IllegalStateException("fluid type not registered: " + String.valueOf(fluidType));
        }
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("block/" + id.getPath()));
        if (!this.fileHelper.exists(texture, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE)) {
            throw new IllegalStateException("Could not find a texture for fluid " + String.valueOf(id) + ". You can provide one at " + String.valueOf(texture) + " or override fluidTextureId to use a different texture location.");
        }
        return texture;
    }

    public static class RenderTypes {
        public static final ResourceLocation SOLID = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"solid");
        public static final ResourceLocation CUTOUT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cutout");
        public static final ResourceLocation CUTOUT_MIPPED = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cutout_mipped");
        public static final ResourceLocation CUTOUT_MIPPED_ALL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"cutout_mipped_all");
        public static final ResourceLocation TRANSLUCENT = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"translucent");
        public static final ResourceLocation TRIPWIRE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"tripwire");

        private RenderTypes() {
        }
    }
}

