/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.moddingx.libx.LibX;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.RegistrySet;
import org.moddingx.libx.datagen.loot.LootBuilders;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;
import org.moddingx.libx.datagen.provider.loot.entry.GenericLootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.LootFactory;
import org.moddingx.libx.datagen.provider.loot.entry.LootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.SimpleLootFactory;
import org.moddingx.libx.impl.datagen.loot.LootData;
import org.moddingx.libx.mod.ModX;

public abstract class LootProviderBase<T>
extends RegistryProviderBase {
    protected final ModX mod;
    protected final RegistrySet registries;
    protected final String folder;
    protected final LootContextParamSet params;
    protected final Supplier<Stream<Map.Entry<ResourceLocation, T>>> modElements;
    protected final Function<T, ResourceLocation> idResolver;
    private final Set<T> ignored = new HashSet<T>();
    private final Map<T, Function<T, LootTable.Builder>> functionMap = new HashMap<T, Function<T, LootTable.Builder>>();

    protected LootProviderBase(DatagenContext ctx, String folder, LootContextParamSet params, ResourceKey<? extends Registry<T>> registryKey) {
        this(ctx, folder, params, () -> ctx.registries().registry(registryKey).entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceKey::location))).map(entry -> Map.entry(((ResourceKey)entry.getKey()).location(), entry.getValue())), id -> ctx.registries().registry(registryKey).getKey(id));
    }

    private LootProviderBase(DatagenContext ctx, String folder, LootContextParamSet params, Supplier<Stream<Map.Entry<ResourceLocation, T>>> modElements, Function<T, ResourceLocation> allElementIds) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
        this.mod = ctx.mod();
        this.registries = ctx.registries();
        this.folder = folder;
        this.params = params;
        this.modElements = modElements;
        this.idResolver = value -> {
            ResourceLocation id = (ResourceLocation)allElementIds.apply(value);
            if (id == null) {
                throw new IllegalStateException("Unregistered value: " + String.valueOf(value));
            }
            return id;
        };
    }

    protected LootProviderBase(DatagenContext ctx, String folder, LootContextParamSet params, Function<T, ResourceLocation> elementIds) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
        this.mod = ctx.mod();
        this.registries = ctx.registries();
        this.folder = folder;
        this.params = params;
        this.modElements = () -> this.functionMap.keySet().stream().map(element -> Map.entry((ResourceLocation)elementIds.apply(element), element));
        this.idResolver = value -> {
            ResourceLocation id = (ResourceLocation)elementIds.apply(value);
            if (id == null) {
                throw new IllegalStateException("Unregistered value: " + String.valueOf(value));
            }
            return id;
        };
    }

    protected abstract void setup();

    protected void customLootTable(T item) {
        this.ignored.add(item);
    }

    protected void customLootTable(T item, LootTable.Builder loot) {
        this.functionMap.put(item, b -> loot);
    }

    protected void customLootTable(T item, Function<T, LootTable.Builder> loot) {
        this.functionMap.put(item, loot);
    }

    protected SimpleLootFactory<T> element() {
        return SimpleLootFactory.from(EmptyLootItem.emptyItem());
    }

    @Nullable
    protected abstract LootTable.Builder defaultBehavior(T var1);

    @Override
    @Nonnull
    public String getName() {
        return this.mod.modid + " " + this.folder + " loot tables";
    }

    @Override
    public void run() {
        this.setup();
        Map<ResourceLocation, LootTable> tables = this.modElements.get().filter(entry -> this.mod.modid.equals(((ResourceLocation)entry.getKey()).getNamespace())).filter(entry -> !this.ignored.contains(entry.getValue())).flatMap(this::resolve).map(entry -> Map.entry(ResourceLocation.fromNamespaceAndPath((String)((ResourceLocation)entry.getKey()).getNamespace(), (String)(this.folder + "/" + ((ResourceLocation)entry.getKey()).getPath())), (LootTable)entry.getValue())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        WritableRegistry registry = this.registries.writableRegistry(Registries.LOOT_TABLE);
        for (Map.Entry<ResourceLocation, LootTable> entry2 : tables.entrySet()) {
            registry.register(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)entry2.getKey()), (Object)entry2.getValue(), RegistrationInfo.BUILT_IN);
        }
        ProblemReporter.Collector problems = new ProblemReporter.Collector();
        HolderLookup.Provider lootTableHolderProvider = HolderLookup.Provider.create(Stream.of(this.registries.registry(Registries.LOOT_TABLE).asLookup()));
        ValidationContext validationContext = new ValidationContext((ProblemReporter)problems, this.params, lootTableHolderProvider.asGetterLookup());
        for (Map.Entry<ResourceLocation, LootTable> entry3 : tables.entrySet()) {
            entry3.getValue().validate(validationContext.setParams(this.params).enterElement("{" + String.valueOf(entry3.getKey()) + "}", ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)entry3.getKey())));
        }
        Multimap multimap = problems.get();
        if (!multimap.isEmpty()) {
            multimap.forEach((where, what) -> LibX.logger.warn("LootTable validation problem in " + where + ": " + what));
            throw new IllegalStateException("There were problems validating the loot tables.");
        }
    }

    private Stream<Map.Entry<ResourceLocation, LootTable>> resolve(Map.Entry<ResourceLocation, T> entry) {
        LootTable.Builder builder;
        Function<Object, LootTable.Builder> loot;
        if (this.functionMap.containsKey(entry.getValue())) {
            loot = this.functionMap.get(entry.getValue());
        } else {
            builder = this.defaultBehavior(entry.getValue());
            Function<Object, LootTable.Builder> function = loot = builder == null ? null : b -> builder;
        }
        if (loot == null) {
            return Stream.empty();
        }
        builder = loot.apply(entry.getValue());
        if (builder.randomSequence.isEmpty()) {
            builder.setRandomSequence(entry.getKey());
        }
        return Stream.of(Map.entry(entry.getKey(), loot.apply(entry.getValue()).setParamSet(this.params).build()));
    }

    protected final LootModifier<T> modifier(BiFunction<T, LootPoolSingletonContainer.Builder<?>, LootPoolSingletonContainer.Builder<?>> function) {
        return LootModifier.of(this.element(), function);
    }

    protected final GenericLootModifier<T> genericModifier(BiFunction<T, LootPoolSingletonContainer.Builder<?>, LootPoolEntryContainer.Builder<?>> function) {
        return GenericLootModifier.of(this.element(), function);
    }

    protected final LootModifier<T> identity() {
        return LootModifier.identity(this.element());
    }

    public void drops(T item, ItemStack ... drops) {
        this.drops(item, Arrays.stream(drops).map(this::stack).toList());
    }

    @SafeVarargs
    public final void drops(T item, LootFactory<T> ... loot) {
        this.drops(item, Arrays.stream(loot).toList());
    }

    public void drops(T item, List<LootFactory<T>> loot) {
        this.generateBaseTable(item, this.combine(loot).build(item));
    }

    public void generateBaseTable(T item, LootPoolEntryContainer.Builder<?> entry) {
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(entry);
        this.customLootTable(item, LootTable.lootTable().withPool(pool));
    }

    public SimpleLootFactory<T> from(LootPoolSingletonContainer.Builder<?> entry) {
        return SimpleLootFactory.from(entry);
    }

    public LootFactory<T> from(LootPoolEntryContainer.Builder<?> entry) {
        return LootFactory.from(entry);
    }

    public LootModifier<T> from(LootItemConditionalFunction.Builder<?> function) {
        return this.modifier((item, entry) -> entry.apply((LootItemFunction.Builder)function));
    }

    public SimpleLootFactory<T> reference(T value) {
        ResourceLocation elementId = this.idResolver.apply(value);
        return this.reference((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)elementId.getNamespace(), (String)(this.folder + "/" + elementId.getPath()))));
    }

    public SimpleLootFactory<T> reference(ResourceKey<LootTable> lootTable) {
        return SimpleLootFactory.from(NestedLootTable.lootTableReference(lootTable));
    }

    public LootItemCondition.Builder random(float chance) {
        return LootItemRandomChanceCondition.randomChance((float)chance);
    }

    public LootModifier<T> count(int count) {
        return this.from(SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)count)));
    }

    public LootModifier<T> count(int min, int max) {
        if (min == max) {
            return this.from(SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)min)));
        }
        return this.from(SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max)));
    }

    public LootModifier<T> countBinomial(float chance, int num) {
        return this.from(SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)num, (float)chance)));
    }

    public LootItemCondition.Builder not(LootItemCondition.Builder condition) {
        return InvertedLootItemCondition.invert((LootItemCondition.Builder)condition);
    }

    public LootItemCondition.Builder and(LootItemCondition.Builder ... conditions) {
        return AllOfCondition.allOf((LootItemCondition.Builder[])conditions);
    }

    public LootItemCondition.Builder or(LootItemCondition.Builder ... conditions) {
        return AnyOfCondition.anyOf((LootItemCondition.Builder[])conditions);
    }

    public SimpleLootFactory<T> stack(ItemLike item) {
        return this.from(LootItem.lootTableItem((ItemLike)item));
    }

    public SimpleLootFactory<T> stack(ItemStack stack) {
        return this.from(LootData.stack(stack));
    }

    @SafeVarargs
    public final LootFactory<T> combine(LootFactory<T> ... loot) {
        return this.combine(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> combine(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::all, l -> l.build(e), loot);
    }

    @SafeVarargs
    public final LootFactory<T> random(LootFactory<T> ... loot) {
        return this.random(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> random(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::group, l -> l.build(e), loot);
    }

    @SafeVarargs
    public final LootFactory<T> first(LootFactory<T> ... loot) {
        return this.first(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> first(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::alternative, l -> l.build(e), loot);
    }

    @SafeVarargs
    public final LootFactory<T> whileMatch(LootFactory<T> ... loot) {
        return this.whileMatch(Arrays.stream(loot).toList());
    }

    public final LootFactory<T> whileMatch(List<LootFactory<T>> loot) {
        return e -> LootData.combineBy(LootBuilders::sequence, l -> l.build(e), loot);
    }
}

