/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.config.mapper;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.moddingx.libx.config.correct.ConfigCorrection;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.ConfigImpl;

public interface GenericValueMapper<T, E extends JsonElement, C> {
    public Class<T> type();

    public Class<E> element();

    public int getGenericElementPosition();

    public T fromJson(E var1, ValueMapper<C, JsonElement> var2);

    public E toJson(T var1, ValueMapper<C, JsonElement> var2);

    default public StreamCodec<? super FriendlyByteBuf, T> streamCodec(ValueMapper<C, JsonElement> mapper) {
        return StreamCodec.of((buf, value) -> buf.writeUtf(ConfigImpl.INTERNAL.toJson(this.toJson(value, mapper)), 262144), buf -> this.fromJson((JsonElement)ConfigImpl.INTERNAL.fromJson(buf.readUtf(262144), this.element()), mapper));
    }

    default public List<String> comment() {
        return List.of();
    }

    default public Optional<T> correct(JsonElement json, ValueMapper<C, JsonElement> mapper, ConfigCorrection<T> correction) {
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ConfigEditor<T> createEditor(ValueMapper<C, JsonElement> var1, ValidatorInfo<?> var2);
}

