/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base.tile;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.BlockEntityUpdateQueue;

public class BlockEntityBase
extends BlockEntity {
    public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public final <T, C> T getCapability(BlockCapability<T, C> capability, C context) {
        if (this.level == null) {
            return null;
        }
        return (T)this.level.getCapability(capability, this.getBlockPos(), this.getBlockState(), (BlockEntity)this, context);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && this.level.isClientSide) {
            LibX.getNetwork().requestBE(this.level, this.worldPosition);
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
    }

    public void setDispatchable() {
        if (this.level != null && !this.level.isClientSide) {
            BlockEntityUpdateQueue.scheduleUpdate(this.level, this.worldPosition);
        }
    }
}

