/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base.tile;

import java.lang.reflect.Constructor;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.moddingx.libx.base.BlockBase;
import org.moddingx.libx.base.tile.GameEventBlock;
import org.moddingx.libx.base.tile.TickingBlock;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class BlockBE<T extends BlockEntity>
extends BlockBase
implements EntityBlock {
    private final Class<T> beClass;
    private final Constructor<T> beConstructor;
    private final BlockEntityType<T> beType;

    public BlockBE(ModX mod, Class<T> beClass, BlockBehaviour.Properties properties) {
        this(mod, beClass, properties, new Item.Properties());
    }

    public BlockBE(ModX mod, Class<T> beClass, BlockBehaviour.Properties properties, @Nullable Item.Properties itemProperties) {
        super(mod, properties, itemProperties);
        this.beClass = beClass;
        try {
            this.beConstructor = beClass.getConstructor(BlockEntityType.class, BlockPos.class, BlockState.class);
        }
        catch (ReflectiveOperationException e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            throw new RuntimeException("Could not get constructor for block entity " + String.valueOf(beClass) + ".", e);
        }
        this.beType = new BlockEntityType((pos, state) -> {
            try {
                return (BlockEntity)this.beConstructor.newInstance(this.getBlockEntityType(), pos, state);
            }
            catch (ReflectiveOperationException e) {
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                throw new RuntimeException("Could not create BlockEntity of type " + String.valueOf(beClass) + ".", e);
            }
        }, Set.of(this), null);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        super.registerAdditional(ctx, builder);
        builder.register(Registries.BLOCK_ENTITY_TYPE, this.beType);
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.beType.create(pos, state);
    }

    @Nullable
    public <X extends BlockEntity> BlockEntityTicker<X> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<X> beType) {
        if (this.beType.isValid(state) && TickingBlock.class.isAssignableFrom(this.beClass)) {
            return new BlockEntityTicker<X>(this){

                public void tick(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull X blockEntity) {
                    if (blockEntity instanceof TickingBlock) {
                        TickingBlock ticking = (TickingBlock)blockEntity;
                        ticking.tick();
                    }
                }
            };
        }
        return null;
    }

    @Nullable
    public <X extends BlockEntity> GameEventListener getListener(@Nonnull ServerLevel level, @Nonnull X blockEntity) {
        if (blockEntity instanceof GameEventBlock) {
            GameEventBlock eventBlock = (GameEventBlock)blockEntity;
            BlockPositionSource source = new BlockPositionSource(blockEntity.getBlockPos());
            return new GameEventListener(){
                final /* synthetic */ PositionSource val$source;
                final /* synthetic */ GameEventBlock val$eventBlock;
                {
                    this.val$source = positionSource;
                    this.val$eventBlock = gameEventBlock;
                }

                @Nonnull
                public PositionSource getListenerSource() {
                    return this.val$source;
                }

                public int getListenerRadius() {
                    return this.val$eventBlock.gameEventRange();
                }

                public boolean handleGameEvent(@Nonnull ServerLevel level, @Nonnull Holder<GameEvent> gameEvent, @Nonnull GameEvent.Context context, @Nonnull Vec3 pos) {
                    return this.val$eventBlock.notifyGameEvent(level, gameEvent, context, pos);
                }

                @Nonnull
                public GameEventListener.DeliveryMode getDeliveryMode() {
                    return this.val$eventBlock.gameEventDelivery();
                }
            };
        }
        return null;
    }

    public void onRemove(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        Object object;
        BlockEntity be;
        if (!(level.isClientSide || state.is(newState.getBlock()) && newState.hasBlockEntity() || !this.shouldDropInventory(level, pos, state) || (be = level.getBlockEntity(pos)) == null || !((object = level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null)) instanceof IItemHandlerModifiable))) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)object;
            for (int i = 0; i < modifiable.getSlots(); ++i) {
                ItemStack stack = modifiable.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, stack.copy());
                level.addFreshEntity((Entity)entity);
                modifiable.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public T getBlockEntity(Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null || !this.beClass.isAssignableFrom(be.getClass())) {
            throw new IllegalStateException("Expected a block entity of type " + String.valueOf(this.beClass) + " at " + String.valueOf(level) + " " + String.valueOf(pos) + ", got" + String.valueOf(be));
        }
        return (T)be;
    }

    public BlockEntityType<T> getBlockEntityType() {
        return this.beType;
    }

    protected boolean shouldDropInventory(Level level, BlockPos pos, BlockState state) {
        return true;
    }
}

