/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.moddingx.libx.creativetab.CreativeTabItemProvider;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class BlockBase
extends Block
implements Registerable,
CreativeTabItemProvider {
    protected final ModX mod;
    private final boolean hasItem;
    @Nullable
    private final Item item;

    public BlockBase(ModX mod, BlockBehaviour.Properties properties) {
        this(mod, properties, new Item.Properties());
    }

    public BlockBase(ModX mod, BlockBehaviour.Properties properties, @Nullable Item.Properties itemProperties) {
        super(properties);
        this.mod = mod;
        if (itemProperties == null) {
            this.hasItem = false;
            this.item = null;
        } else {
            this.hasItem = true;
            this.item = new BaseBlockItem(this, itemProperties);
        }
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return 0;
    }

    @Override
    public Stream<ItemStack> makeCreativeTabStacks() {
        return Stream.of(new ItemStack((ItemLike)this));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        if (this.hasItem) {
            builder.register(Registries.ITEM, this.item);
        }
    }

    private class BaseBlockItem
    extends BlockItem
    implements CreativeTabItemProvider {
        public BaseBlockItem(Block block, Item.Properties itemProperties) {
            super(block, itemProperties);
        }

        public int getBurnTime(@Nonnull ItemStack stack, @Nullable RecipeType<?> recipeType) {
            return BlockBase.this.getBurnTime(stack, recipeType);
        }

        @Override
        public Stream<ItemStack> makeCreativeTabStacks() {
            return BlockBase.this.makeCreativeTabStacks();
        }
    }
}

