/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.recipe;

import com.benbenlaw.core.item.CoreDataComponents;
import com.benbenlaw.core.item.colored.ColoredBlockItem;
import com.benbenlaw.core.item.colored.ColoringItem;
import com.benbenlaw.core.recipe.CoreRecipes;
import com.benbenlaw.core.util.ColorList;
import com.benbenlaw.core.util.CoreTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ColoringRecipe
extends CustomRecipe {
    public ColoringRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        ItemStack coloredBlockItem = ItemStack.EMPTY;
        ItemStack sprayCanItem = ItemStack.EMPTY;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ColoredBlockItem && !stack.is(CoreTags.Items.BANNED_FROM_COLORING)) {
                if (!coloredBlockItem.isEmpty()) {
                    return false;
                }
                coloredBlockItem = stack;
                continue;
            }
            if (stack.getItem() instanceof ColoringItem) {
                if (!sprayCanItem.isEmpty()) {
                    return false;
                }
                sprayCanItem = stack;
                continue;
            }
            if (this.containsColor(stack) && !(stack.getItem() instanceof ColoredBlockItem)) {
                if (!coloredBlockItem.isEmpty()) {
                    return false;
                }
                coloredBlockItem = stack;
                continue;
            }
            return false;
        }
        return !coloredBlockItem.isEmpty() && !sprayCanItem.isEmpty();
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        DyeColor sprayColor;
        ItemStack result;
        ItemStack coloredBlockItem = ItemStack.EMPTY;
        ColoringItem sprayCanItem = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack stack = craftingInput.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ColoredBlockItem) {
                if (!coloredBlockItem.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                coloredBlockItem = stack.copy();
                continue;
            }
            if (stack.getItem() instanceof ColoringItem) {
                if (sprayCanItem != null) {
                    return ItemStack.EMPTY;
                }
                sprayCanItem = (ColoringItem)stack.getItem();
                continue;
            }
            if (!this.containsColor(stack)) continue;
            if (!coloredBlockItem.isEmpty()) {
                return ItemStack.EMPTY;
            }
            coloredBlockItem = stack.copy();
        }
        if (!coloredBlockItem.isEmpty() && sprayCanItem != null && !(result = this.applyColorToBlock(coloredBlockItem, sprayColor = sprayCanItem.getColor())).isEmpty()) {
            result.setCount(1);
            return result;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    private ItemStack applyColorToBlock(ItemStack stack, DyeColor color) {
        if (stack.getItem() instanceof ColoredBlockItem) {
            String colorString = color.getName();
            stack.set(CoreDataComponents.COLOR, (Object)colorString);
            return stack;
        }
        for (String colorCheck : ColorList.COLORS) {
            if (!stack.getItem().toString().contains(colorCheck) || stack.getItem() instanceof ColoredBlockItem) continue;
            String resourceLocationString = stack.getItem().toString().replace(colorCheck, color.toString().toLowerCase());
            try {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)resourceLocationString);
                if (resourceLocation == null || !BuiltInRegistries.ITEM.containsKey(resourceLocation)) continue;
                return ((Item)BuiltInRegistries.ITEM.get(resourceLocation)).getDefaultInstance();
            }
            catch (IllegalArgumentException e) {
                System.out.println("Failed to parse resource location: " + resourceLocationString);
                return ItemStack.EMPTY;
            }
        }
        return ItemStack.EMPTY;
    }

    private boolean containsColor(ItemStack stack) {
        for (String colorCheck : ColorList.COLORS) {
            if (!stack.getItem().toString().contains(colorCheck) || stack.getItem() instanceof ColoringItem) continue;
            return true;
        }
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return CoreRecipes.COLORING_SERIALIZER.get();
    }
}

