/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.mixin.compat;

import com.benbenlaw.core.block.UnbreakableResourceBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"com.direwolf20.justdirethings.common.blockentities.BlockBreakerT1BE"})
public class JustDireBlockBreakersMixin {
    @Unique
    private static Class<?> blockBreakerT1BEClass;

    @Inject(method={"breakBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void breakBlock(FakePlayer player, BlockPos breakPos, ItemStack itemStack, BlockState state, CallbackInfo ci) {
        Block block = state.getBlock();
        if (blockBreakerT1BEClass != null && blockBreakerT1BEClass.isInstance(this)) {
            try {
                Level level = player.level();
                if (breakPos != null) {
                    BlockEntity blockEntity = level.getBlockEntity(breakPos);
                    if (block instanceof UnbreakableResourceBlock) {
                        UnbreakableResourceBlock unbreakableResourceBlock = (UnbreakableResourceBlock)block;
                        int dropHeightModifier = unbreakableResourceBlock.dropHeightModifier;
                        BlockPos modifiedBlockPos = new BlockPos(breakPos.getX(), breakPos.getY() + dropHeightModifier, breakPos.getZ());
                        Block.dropResources((BlockState)state, (Level)level, (BlockPos)modifiedBlockPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)itemStack);
                        level.setBlock(breakPos, (BlockState)state.setValue((Property)UnbreakableResourceBlock.RESTING, (Comparable)Boolean.valueOf(true)), 3);
                        level.scheduleTick(breakPos, state.getBlock(), 20);
                        if (state.getDestroySpeed((BlockGetter)player.level(), breakPos) != 0.0f) {
                            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
                        }
                        ci.cancel();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            blockBreakerT1BEClass = Class.forName("com.direwolf20.justdirethings.common.blockentities.BlockBreakerT1BE");
        }
        catch (ClassNotFoundException e) {
            blockBreakerT1BEClass = null;
        }
    }
}

