/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.util.BlockInformation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="bblcore")
public class UnbreakableBlockReplaceEvent {
    public static final Map<BlockPos, BlockInformation> blockInformationMap = new HashMap<BlockPos, BlockInformation>();

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (blockInformationMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<BlockPos, BlockInformation>> iterator = blockInformationMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, BlockInformation> entry = iterator.next();
            BlockPos pos = entry.getKey();
            BlockInformation blockInfo = entry.getValue();
            Level level = blockInfo.level();
            if (level.isClientSide() || (long)Objects.requireNonNull(level.getServer()).getTickCount() < blockInfo.tickPlace()) continue;
            level.setBlockAndUpdate(pos, blockInfo.state());
            iterator.remove();
        }
    }
}

