/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.event;

import com.benbenlaw.core.config.CoreDimensionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;

@EventBusSubscriber(modid="bblcore")
public class SleepingInOtherDimensionsEvent {
    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)player2.level();
        if (level.isClientSide()) {
            return;
        }
        ArrayList configuredDims = new ArrayList((Collection)CoreDimensionConfig.dimensionNames.get());
        boolean isConfiguredDim = configuredDims.stream().map(ResourceLocation::tryParse).filter(Objects::nonNull).anyMatch(dim -> dim.equals((Object)level.dimension().location()));
        if (!isConfiguredDim) {
            return;
        }
        MinecraftServer server = player2.server;
        long currentTime = level.getDayTime();
        long newTime = (currentTime / 24000L + 1L) * 24000L;
        String command = "time set " + newTime;
        server.getCommands().performPrefixedCommand(server.createCommandSourceStack().withLevel(level).withSuppressedOutput(), command);
    }
}

