/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.brightable;

import com.benbenlaw.core.block.brightable.IBrightable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class BrightLog
extends RotatedPillarBlock
implements IBrightable {
    public static Map<Block, Block> logStrippedMap = new HashMap<Block, Block>();
    public static Map<Block, Block> woodStrippedMap = new HashMap<Block, Block>();
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public BrightLog(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.FALSE)).setValue((Property)AXIS, (Comparable)Direction.Axis.Y));
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (context.getItemInHand().getItem() instanceof AxeItem) {
            Block block = state.getBlock();
            if (logStrippedMap.containsKey(block)) {
                return (BlockState)logStrippedMap.get(block).defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)));
            }
            if (woodStrippedMap.containsKey(block)) {
                return (BlockState)woodStrippedMap.get(block).defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)));
            }
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, AXIS});
    }

    public static void updateLogStrippedMap(Block original, Block stripped) {
        logStrippedMap.put(original, stripped);
    }

    public static void updateWoodStrippedMap(Block original, Block stripped) {
        woodStrippedMap.put(original, stripped);
    }
}

