/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnbreakableResourceBlock
extends Block {
    public int dropHeightModifier;
    public Supplier<Item> toolToCollectTheBlockAsItem;
    public TagKey<Item> toolToCollectTheBlockAsTag;
    public String particle;
    public int progress;
    private static boolean warnedAboutMissingParticle = false;
    public static final BooleanProperty RESTING = BooleanProperty.create((String)"resting");

    public UnbreakableResourceBlock(BlockBehaviour.Properties properties, int dropHeightModifier, String toolToCollectTheBlock, String particle) {
        super(properties);
        this.dropHeightModifier = dropHeightModifier;
        this.particle = particle;
        if (toolToCollectTheBlock.startsWith("#")) {
            this.toolToCollectTheBlockAsTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)toolToCollectTheBlock.substring(1)));
        } else {
            this.toolToCollectTheBlockAsItem = () -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)toolToCollectTheBlock));
        }
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)RESTING, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RESTING});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        super.destroy(level, pos, state);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, (BlockState)state.setValue((Property)RESTING, (Comparable)Boolean.valueOf(false)), 3);
        super.tick(state, level, pos, random);
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        boolean isCorrectTool = false;
        if (this.toolToCollectTheBlockAsTag != null) {
            isCorrectTool = tool.is(this.toolToCollectTheBlockAsTag);
        }
        if (this.toolToCollectTheBlockAsItem != null) {
            boolean bl = isCorrectTool = isCorrectTool || ItemStack.isSameItemSameComponents((ItemStack)tool, (ItemStack)new ItemStack((ItemLike)this.toolToCollectTheBlockAsItem.get()));
        }
        if (!isCorrectTool) {
            level.setBlock(pos, (BlockState)this.defaultBlockState().setValue((Property)RESTING, (Comparable)Boolean.valueOf(true)), 3);
            level.scheduleTick(pos, (Block)this, 20);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.toolToCollectTheBlockAsItem != null) {
            Component name = this.toolToCollectTheBlockAsItem.get().getName(this.toolToCollectTheBlockAsItem.get().getDefaultInstance());
            tooltipComponents.add((Component)Component.translatable((String)"tooltips.bblcore.block.unbreakable_resource_block_tool", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY));
        }
        if (this.toolToCollectTheBlockAsTag != null) {
            String tag = this.toolToCollectTheBlockAsTag.toString();
            tooltipComponents.add((Component)Component.translatable((String)"tooltips.bblcore.block.unbreakable_resource_block_tool_tag", (Object[])new Object[]{tag}).withStyle(ChatFormatting.GRAY));
        }
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)RESTING)).booleanValue()) {
            return 0.0f;
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        if (((Boolean)state.getValue((Property)RESTING)).booleanValue()) {
            return false;
        }
        return super.canHarvestBlock(state, level, pos, player);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextFloat() < 0.5f) {
            ParticleOptions particleType = (ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)this.particle));
            if (particleType == null) {
                if (!warnedAboutMissingParticle) {
                    System.out.println("Particle not found, defaulting to minecraft:flame!");
                    warnedAboutMissingParticle = true;
                }
                particleType = ParticleTypes.FLAME;
            }
            level.addParticle(particleType, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        }
    }
}

