/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.colors.data.ColorsBlockStatesProvider;
import com.benbenlaw.colors.data.ColorsBlockTags;
import com.benbenlaw.colors.data.ColorsDataMaps;
import com.benbenlaw.colors.data.ColorsItemModelProvider;
import com.benbenlaw.colors.data.ColorsItemTags;
import com.benbenlaw.colors.data.ColorsLangProvider;
import com.benbenlaw.colors.data.ColorsLootTableProvider;
import com.benbenlaw.colors.data.ColorsRecipesBuilder;
import com.benbenlaw.colors.data.ColorsWorldGenProviders;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="colors", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ColorsRecipesBuilder(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ColorsLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        ColorsBlockTags blockTags = new ColorsBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        ColorsItemTags itemTags = new ColorsItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeClient(), (DataProvider)new ColorsItemModelProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ColorsBlockStatesProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ColorsLangProvider(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new ColorsWorldGenProviders(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ColorsDataMaps(packOutput, lookupProvider));
    }
}

