/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.item.ColorsItems;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class ColorsLootTableProvider
extends VanillaBlockLoot {
    HolderLookup.RegistryLookup<Enchantment> registrylookup;
    private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
    protected static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));
    private final Set<Block> knownBlocks;

    public ColorsLootTableProvider(HolderLookup.Provider provider) {
        super(provider);
        this.registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        this.knownBlocks = new ReferenceOpenHashSet();
    }

    protected void generate() {
        DeferredBlock<Block> block2;
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.STONE_BLOCKS.entrySet()) {
            if (entry.getKey().endsWith("_slab")) {
                this.add((Block)entry.getValue().get(), x$0 -> this.createSlabItemTable((Block)x$0));
                continue;
            }
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.PLANKS.entrySet()) {
            if (entry.getKey().endsWith("_slab")) {
                this.add((Block)entry.getValue().get(), x$0 -> this.createSlabItemTable((Block)x$0));
                continue;
            }
            if (entry.getKey().endsWith("_door")) {
                this.add((Block)entry.getValue().get(), x$0 -> this.createDoorTable((Block)x$0));
                continue;
            }
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.DIRT.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.GRASS_BLOCK.entrySet()) {
            String dirt = entry.getKey().replace("_grass_block", "_dirt");
            block2 = ColorsBlocks.DIRT.get(dirt);
            this.add((Block)entry.getValue().get(), this.createSingleItemTableWithSilkTouch((Block)entry.getValue().get(), (ItemLike)block2));
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.CRAFTING_TABLE.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.SHORT_GRASS.entrySet()) {
            this.add((Block)entry.getValue().get(), this.createGrassDrops((Block)entry.getValue().get()));
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.TALL_GRASS.entrySet()) {
            String shortGrassBlock = entry.getKey().replace("_tall_grass", "_short_grass");
            block2 = ColorsBlocks.SHORT_GRASS.get(shortGrassBlock);
            this.add((Block)entry.getValue().get(), this.createDoublePlantWithSeedDrops((Block)entry.getValue().get(), (Block)block2.get()));
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.POPPY.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
            String poppyBlock = entry.getKey().replace("_poppy", "_potted_poppy");
            block2 = ColorsBlocks.POTTED_POPPY.get(poppyBlock);
            this.add((Block)block2.get(), this.createPotFlowerItemTable((ItemLike)entry.getValue().get()));
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.DANDELION.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
            String dandelionBlock = entry.getKey().replace("_dandelion", "_potted_dandelion");
            block2 = ColorsBlocks.POTTED_DANDELION.get(dandelionBlock);
            this.add((Block)block2.get(), this.createPotFlowerItemTable((ItemLike)entry.getValue().get()));
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.LOGS.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.WOOD.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.BAMBOO.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.SAPLINGS.entrySet()) {
            this.dropSelf((Block)entry.getValue().get());
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.LEAVES.entrySet()) {
            String sapling = entry.getKey().replace("_leaves", "_sapling");
            DeferredBlock<Block> saplingBlock = ColorsBlocks.SAPLINGS.get(sapling);
            String apple = entry.getKey().replace("_leaves", "_apple");
            DeferredItem<Item> appleItem = ColorsItems.APPLES.get(apple);
            this.add((Block)entry.getValue().get(), block -> this.createBrightLeavesDrops((Block)block, (Block)saplingBlock.get(), (Item)appleItem.get(), NORMAL_LEAVES_SAPLING_CHANCES));
        }
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return HAS_SHEARS.or(this.hasSilkTouch());
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
        return this.hasShearsOrSilkTouch().invert();
    }

    protected LootTable.Builder createBrightLeavesDrops(Block p_249535_, Block p_251505_, Item apple, float ... p_250753_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(p_249535_, p_251505_, p_250753_).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_249535_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)apple))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected LootTable.Builder createLeavesDrops(Block p_250088_, Block p_250731_, float ... p_248949_) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(p_250088_, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)p_250088_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)p_250731_))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])p_248949_))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)p_250088_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))));
    }

    protected LootTable.Builder createSilkTouchOrShearsDispatchTable(Block p_250539_, LootPoolEntryContainer.Builder<?> p_251459_) {
        return ColorsLootTableProvider.createSelfDropDispatchTable((Block)p_250539_, (LootItemCondition.Builder)this.hasShearsOrSilkTouch(), p_251459_);
    }

    protected void add(@NotNull Block block, @NotNull LootTable.Builder table) {
        super.add(block, table);
        this.knownBlocks.add(block);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }
}

