/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.colors.block.sets.PlankLikeBlocksList;
import com.benbenlaw.colors.block.sets.StoneLikeBlocksList;
import com.benbenlaw.core.util.ColorList;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ColorsLangProvider
extends LanguageProvider {
    public ColorsLangProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "colors", "en_us");
    }

    protected void addTranslations() {
        this.addTranslation("creative.colors.tab", "Colors");
        for (String color : ColorList.COLORS) {
            for (String type : StoneLikeBlocksList.STONE_BLOCKS) {
                String baseKey = color + "_" + type;
                String baseName = this.formatName(color) + " " + this.formatName(type);
                this.addBlockTranslation(baseKey, baseName);
                String variantType = this.getVariantType(type);
                String variantKeyPrefix = color + "_" + variantType;
                String variantNameBase = this.formatName(color) + " " + this.formatName(variantType);
                this.addBlockTranslation(variantKeyPrefix + "_stairs", variantNameBase + " Stairs");
                this.addBlockTranslation(variantKeyPrefix + "_slab", variantNameBase + " Slab");
                this.addBlockTranslation(variantKeyPrefix + "_wall", variantNameBase + " Wall");
                this.addBlockTranslation(variantKeyPrefix + "_pressure_plate", variantNameBase + " Pressure Plate");
                this.addBlockTranslation(variantKeyPrefix + "_button", variantNameBase + " Button");
            }
            for (String type : PlankLikeBlocksList.PLANKS) {
                String singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                String keyPrefix = color + "_" + singularType;
                this.addBlockTranslation(color + "_" + type, this.formatName(color) + " " + this.formatName(type));
                this.addBlockTranslation(keyPrefix + "_stairs", this.formatName(color) + " " + this.formatName(singularType) + " Stairs");
                this.addBlockTranslation(keyPrefix + "_slab", this.formatName(color) + " " + this.formatName(singularType) + " Slab");
                this.addBlockTranslation(keyPrefix + "_fence", this.formatName(color) + " " + this.formatName(singularType) + " Fence");
                this.addBlockTranslation(keyPrefix + "_fence_gate", this.formatName(color) + " " + this.formatName(singularType) + " Fence Gate");
                this.addBlockTranslation(keyPrefix + "_pressure_plate", this.formatName(color) + " " + this.formatName(singularType) + " Pressure Plate");
                this.addBlockTranslation(keyPrefix + "_button", this.formatName(color) + " " + this.formatName(singularType) + " Button");
                this.addBlockTranslation(keyPrefix + "_trapdoor", this.formatName(color) + " " + this.formatName(singularType) + " Trapdoor");
                this.addBlockTranslation(keyPrefix + "_door", this.formatName(color) + " " + this.formatName(singularType) + " Door");
            }
            this.addBlockTranslation(color + "_dirt", this.formatName(color) + " Dirt");
            this.addBlockTranslation(color + "_grass_block", this.formatName(color) + " Grass Block");
            this.addBlockTranslation(color + "_crafting_table", this.formatName(color) + " Crafting Table");
            this.addBlockTranslation(color + "_tall_grass", this.formatName(color) + " Tall Grass");
            this.addBlockTranslation(color + "_short_grass", this.formatName(color) + " Short Grass");
            this.addBlockTranslation(color + "_poppy", this.formatName(color) + " Poppy");
            this.addBlockTranslation(color + "_potted_poppy", this.formatName(color) + " Potted Poppy");
            this.addBlockTranslation(color + "_dandelion", this.formatName(color) + " Dandelion");
            this.addBlockTranslation(color + "_leaves", this.formatName(color) + " Leaves");
            this.addBlockTranslation(color + "_log", this.formatName(color) + " Log");
            this.addBlockTranslation(color + "_stripped_log", this.formatName(color) + " Stripped Log");
            this.addBlockTranslation(color + "_wood", this.formatName(color) + " Wood");
            this.addBlockTranslation(color + "_stripped_wood", this.formatName(color) + " Stripped Wood");
            this.addBlockTranslation(color + "_bamboo", this.formatName(color) + " Bamboo");
            this.addBlockTranslation(color + "_stripped_bamboo", this.formatName(color) + " Stripped Bamboo");
            this.addBlockTranslation(color + "_sapling", this.formatName(color) + " Sapling");
            this.addItemTranslation(color + "_spray_can", this.formatName(color) + " Spray Can");
            this.addItemTranslation(color + "_apple", this.formatName(color) + " Apple");
        }
        this.addItemTranslation("glowstone_spray_can", "Glowstone Spray Can");
    }

    private void addBlockTranslation(String name, String translation) {
        this.add("block.colors." + name, translation);
    }

    private void addItemTranslation(String name, String translation) {
        this.add("item.colors." + name, translation);
    }

    private void addTranslation(String name, String translation) {
        super.add(name, translation);
    }

    private String formatName(String input) {
        String[] words = input.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }

    private String getVariantType(String type) {
        if (type.endsWith("tiles")) {
            return type.substring(0, type.length() - "tiles".length()) + "tile";
        }
        if (type.endsWith("bricks")) {
            return type.substring(0, type.length() - "bricks".length()) + "brick";
        }
        return type;
    }
}

