/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.item.ColorsItems;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ColorsItemModelProvider
extends ItemModelProvider {
    public ColorsItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "colors", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ColorsItems.SPRAY_CANS.get("black_spray_can"), "black_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("red_spray_can"), "red_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("green_spray_can"), "green_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("brown_spray_can"), "brown_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("blue_spray_can"), "blue_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("purple_spray_can"), "purple_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("cyan_spray_can"), "cyan_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("light_gray_spray_can"), "light_gray_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("gray_spray_can"), "gray_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("pink_spray_can"), "pink_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("lime_spray_can"), "lime_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("yellow_spray_can"), "yellow_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("light_blue_spray_can"), "light_blue_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("magenta_spray_can"), "magenta_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("orange_spray_can"), "orange_spray_can");
        this.simpleItem(ColorsItems.SPRAY_CANS.get("white_spray_can"), "white_spray_can");
        this.simpleItem(ColorsItems.GLOWSTONE_SPRAY_CAN, "glowstone_spray_can");
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.PLANKS.entrySet()) {
            if (entry.getKey().endsWith("_bamboo_mosaic_door")) {
                this.doorItem(entry.getValue(), "bamboo_mosaic_door");
                continue;
            }
            if (entry.getKey().endsWith("_bamboo_plank_door")) {
                this.doorItem(entry.getValue(), "bamboo_plank_door");
                continue;
            }
            if (!entry.getKey().endsWith("_plank_door")) continue;
            this.doorItem(entry.getValue(), "plank_door");
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.SHORT_GRASS.entrySet()) {
            this.saplingItem(entry.getValue(), "short_grass");
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.TALL_GRASS.entrySet()) {
            this.tallGrass(entry.getValue(), "tall_grass");
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.POPPY.entrySet()) {
            this.saplingItem(entry.getValue(), "poppy");
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.DANDELION.entrySet()) {
            this.saplingItem(entry.getValue(), "dandelion");
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.SAPLINGS.entrySet()) {
            this.saplingItem(entry.getValue(), "sapling");
        }
        for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsItems.APPLES.entrySet()) {
            this.simpleItem((DeferredItem<Item>)((DeferredItem)entry.getValue()), "apple");
        }
    }

    private void simpleItem(DeferredItem<Item> item, String defaultTexture) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("item/" + defaultTexture)));
    }

    private void doorItem(DeferredBlock<Block> item, String defaultTexture) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("item/" + defaultTexture)));
    }

    private void saplingItem(DeferredBlock<Block> item, String defaultTexture) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("block/" + defaultTexture)));
    }

    private void tallGrass(DeferredBlock<Block> item, String defaultTexture) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)("block/" + defaultTexture + "_top")));
    }
}

