/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.data;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.block.sets.PlankLikeBlocksList;
import com.benbenlaw.colors.block.sets.StoneLikeBlocksList;
import com.benbenlaw.core.block.brightable.BrightCraftingTable;
import com.benbenlaw.core.block.brightable.BrightDoublePlantBlock;
import com.benbenlaw.core.block.brightable.BrightTallGrassBlock;
import com.benbenlaw.core.block.colored.ColoredBlock;
import com.benbenlaw.core.block.colored.ColoredDoor;
import com.benbenlaw.core.block.colored.ColoredDoublePlantBlock;
import com.benbenlaw.core.block.colored.ColoredFence;
import com.benbenlaw.core.block.colored.ColoredFlower;
import com.benbenlaw.core.block.colored.ColoredSapling;
import com.benbenlaw.core.block.colored.ColoredStairs;
import com.benbenlaw.core.block.colored.ColoredTallGrassBlock;
import com.benbenlaw.core.block.colored.ColoredTrapDoor;
import com.benbenlaw.core.util.ColorList;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ColorsBlockStatesProvider
extends BlockStateProvider {
    public ColorsBlockStatesProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "colors", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        for (String color : ColorList.COLORS) {
            String keyPrefix;
            String singularType;
            this.saplingWithElements((SaplingBlock)ColorsBlocks.SAPLINGS.get(color + "_sapling").get(), "colors:block/sapling");
            this.logBlockWithElement((Block)ColorsBlocks.LOGS.get(color + "_log").get(), "colors:block/log");
            this.strippedLogBlockWithElement((RotatedPillarBlock)ColorsBlocks.LOGS.get(color + "_stripped_log").get(), "colors:block/stripped_log");
            this.woodBlockWithElement((RotatedPillarBlock)ColorsBlocks.WOOD.get(color + "_wood").get(), "colors:block/log");
            this.strippedWoodBlockWithElement((RotatedPillarBlock)ColorsBlocks.WOOD.get(color + "_stripped_wood").get(), "colors:block/stripped_log");
            this.logBlockWithElement((Block)ColorsBlocks.BAMBOO.get(color + "_bamboo").get(), "colors:block/bamboo_block");
            this.strippedLogBlockWithElement((RotatedPillarBlock)ColorsBlocks.BAMBOO.get(color + "_stripped_bamboo").get(), "colors:block/stripped_bamboo_block");
            this.simpleBlockWithElements((Block)ColorsBlocks.LEAVES.get(color + "_leaves").get(), "colors:block/leaves");
            this.tallGrassWithElements((BrightTallGrassBlock)ColorsBlocks.SHORT_GRASS.get(color + "_short_grass").get(), "colors:block/short_grass");
            this.doublePlantWithElements((BrightDoublePlantBlock)ColorsBlocks.TALL_GRASS.get(color + "_tall_grass").get(), "colors:block/tall_grass");
            this.flowerWithElements((FlowerBlock)ColorsBlocks.POPPY.get(color + "_poppy").get(), "colors:block/poppy");
            this.simpleBlock((Block)ColorsBlocks.POTTED_POPPY.get(color + "_potted_poppy").get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_poppy", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)"tintable_flower_pot_cross"), "plant", ResourceLocation.parse((String)"colors:block/poppy"))).renderType("cutout"));
            this.flowerWithElements((FlowerBlock)ColorsBlocks.DANDELION.get(color + "_dandelion").get(), "colors:block/dandelion");
            this.simpleBlock((Block)ColorsBlocks.POTTED_DANDELION.get(color + "_potted_dandelion").get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture("potted_dandelion", ResourceLocation.fromNamespaceAndPath((String)"colors", (String)"tintable_flower_pot_cross"), "plant", ResourceLocation.parse((String)"colors:block/dandelion"))).renderType("cutout"));
            this.simpleBlockWithElements((Block)ColorsBlocks.DIRT.get(color + "_dirt").get(), "colors:block/dirt");
            this.grassBlockWithElements((GrassBlock)ColorsBlocks.GRASS_BLOCK.get(color + "_grass_block").get(), "colors:block/dirt", "colors:block/grass_block");
            this.craftingTableBlock((BrightCraftingTable)ColorsBlocks.CRAFTING_TABLE.get(color + "_crafting_table").get(), "colors:block/planks", "colors:block/crafting_table");
            for (String type : StoneLikeBlocksList.STONE_BLOCKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                this.simpleBlockWithElements((Block)ColorsBlocks.STONE_BLOCKS.get(color + "_" + type).get(), "colors:block/" + type);
                this.slabWithElements((SlabBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_slab").get(), "colors:block/" + type);
                this.stairsWithElements((StairBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_stairs").get(), "colors:block/" + type);
                this.wallWithElements((WallBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_wall").get(), "colors:block/" + type);
                this.pressurePlateWithElements((PressurePlateBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_pressure_plate").get(), "colors:block/" + type);
                this.buttonWithElements((ButtonBlock)ColorsBlocks.STONE_BLOCKS.get(keyPrefix + "_button").get(), "colors:block/" + type);
            }
            for (String type : PlankLikeBlocksList.PLANKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                this.simpleBlockWithElements((Block)ColorsBlocks.PLANKS.get(color + "_" + type).get(), "colors:block/" + type);
                this.slabWithElements((SlabBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_slab").get(), "colors:block/" + type);
                this.stairsWithElements((StairBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_stairs").get(), "colors:block/" + type);
                this.pressurePlateWithElements((PressurePlateBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_pressure_plate").get(), "colors:block/" + type);
                this.buttonWithElements((ButtonBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_button").get(), "colors:block/" + type);
                this.fenceWithElements((FenceBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_fence").get(), "colors:block/" + type);
                this.fenceGateWithElements((FenceGateBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_fence_gate").get(), "colors:block/" + type);
                this.doorWithElements((DoorBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_door").get(), "colors:block/" + singularType);
                this.trapDoorWithElements((TrapDoorBlock)ColorsBlocks.PLANKS.get(keyPrefix + "_trapdoor").get(), "colors:block/" + singularType + "_trapdoor", true);
            }
        }
    }

    private void strippedWoodBlockWithElement(RotatedPillarBlock strippedWoodBlock, String defaultTexture) {
        ResourceLocation woodBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)strippedWoodBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ResourceLocation textureTop = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder log = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(woodBlockRegistryName.getPath(), "colors:block/tintable_cube_column")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ModelBuilder logHorizontal = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(woodBlockRegistryName.getPath(), "colors:block/tintable_cube_column_horizontal")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)strippedWoodBlock).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)log).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).rotationY(90).addModel();
        this.simpleBlockItem((Block)strippedWoodBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + woodBlockRegistryName.getPath()));
    }

    private void woodBlockWithElement(RotatedPillarBlock woodBlock, String defaultTexture) {
        ResourceLocation woodBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)woodBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ResourceLocation textureTop = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder log = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(woodBlockRegistryName.getPath(), "colors:block/tintable_cube_column")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ModelBuilder logHorizontal = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(woodBlockRegistryName.getPath(), "colors:block/tintable_cube_column_horizontal")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)woodBlock).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)log).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).rotationY(90).addModel();
        this.simpleBlockItem((Block)woodBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + woodBlockRegistryName.getPath()));
    }

    private void logBlockWithElement(Block block, String defaultTexture) {
        ResourceLocation blockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)block);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ResourceLocation textureTop = ResourceLocation.parse((String)(defaultTexture + "_top"));
        ModelBuilder log = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockRegistryName.getPath(), "colors:block/tintable_cube_column")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ModelBuilder logHorizontal = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockRegistryName.getPath(), "colors:block/tintable_cube_column_horizontal")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)log).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).rotationY(90).addModel();
        this.simpleBlockItem(block, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + blockRegistryName.getPath()));
    }

    private void strippedLogBlockWithElement(RotatedPillarBlock strippedLogBlock, String defaultTexture) {
        ResourceLocation strippedLogBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)strippedLogBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ResourceLocation textureTop = ResourceLocation.parse((String)(defaultTexture + "_top"));
        ModelBuilder log = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(strippedLogBlockRegistryName.getPath(), "colors:block/tintable_cube_column")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ModelBuilder logHorizontal = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(strippedLogBlockRegistryName.getPath(), "colors:block/tintable_cube_column_horizontal")).texture("side", texture)).texture("end", textureTop)).renderType("cutout");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)strippedLogBlock).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)log).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).addModel()).partialState().with((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)logHorizontal).rotationX(90).rotationY(90).addModel();
        this.simpleBlockItem((Block)strippedLogBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + strippedLogBlockRegistryName.getPath()));
    }

    private void tallGrassWithElements(BrightTallGrassBlock flowerBlock, String defaultTexture) {
        ResourceLocation saplingBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)flowerBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder sapling = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(saplingBlockRegistryName.getPath(), "colors:block/tintable_cross")).texture("cross", texture)).renderType("cutout");
        this.getVariantBuilder((Block)flowerBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$tallGrassWithElements$0((ModelFile)sapling, arg_0), new Property[]{ColoredTallGrassBlock.LIT, ColoredTallGrassBlock.COLOR});
    }

    private void doublePlantWithElements(BrightDoublePlantBlock flowerBlock, String defaultTexture) {
        ResourceLocation saplingBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)flowerBlock);
        ResourceLocation textureTop = ResourceLocation.parse((String)(defaultTexture + "_top"));
        ResourceLocation textureBottom = ResourceLocation.parse((String)(defaultTexture + "_bottom"));
        ModelBuilder doubleTop = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(saplingBlockRegistryName.getPath() + "_top", "colors:block/tintable_cross")).texture("cross", textureTop)).renderType("cutout");
        ModelBuilder doubleBottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(saplingBlockRegistryName.getPath() + "_bottom", "colors:block/tintable_cross")).texture("cross", textureBottom)).renderType("cutout");
        this.getVariantBuilder((Block)flowerBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$doublePlantWithElements$1((ModelFile)doubleTop, (ModelFile)doubleBottom, arg_0), new Property[]{ColoredDoublePlantBlock.LIT, ColoredDoublePlantBlock.COLOR});
    }

    private void saplingWithElements(SaplingBlock saplingBlock, String defaultTexture) {
        ResourceLocation saplingBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)saplingBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder sapling = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(saplingBlockRegistryName.getPath(), "colors:block/tintable_cross")).texture("cross", texture)).renderType("cutout");
        this.getVariantBuilder((Block)saplingBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$saplingWithElements$2((ModelFile)sapling, arg_0), new Property[]{ColoredSapling.LIT, ColoredSapling.COLOR});
    }

    private void flowerWithElements(FlowerBlock flowerBlock, String defaultTexture) {
        ResourceLocation saplingBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)flowerBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder sapling = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(saplingBlockRegistryName.getPath(), "colors:block/tintable_cross")).texture("cross", texture)).renderType("cutout");
        this.getVariantBuilder((Block)flowerBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$flowerWithElements$3((ModelFile)sapling, arg_0), new Property[]{ColoredFlower.LIT, ColoredFlower.COLOR});
    }

    private void craftingTableBlock(BrightCraftingTable craftingTable, String defaultTexture, String craftingTableTexture) {
        ResourceLocation craftingTableRegistryName = BuiltInRegistries.BLOCK.getKey((Object)craftingTable);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ResourceLocation textureFront = ResourceLocation.parse((String)craftingTableTexture);
        ResourceLocation textureTop = ResourceLocation.parse((String)(craftingTableTexture + "_top"));
        ResourceLocation textureSide = ResourceLocation.parse((String)(craftingTableTexture + "_side"));
        ModelBuilder cubeSides = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(craftingTableRegistryName.getPath(), "colors:block/tintable_cube")).texture("down", texture)).texture("up", textureTop)).texture("north", textureFront)).texture("south", textureSide)).texture("west", textureFront)).texture("east", textureSide)).texture("particle", textureFront)).renderType("cutout");
        this.simpleBlockItem((Block)craftingTable, (ModelFile)cubeSides);
        this.getVariantBuilder((Block)craftingTable).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$craftingTableBlock$4((ModelFile)cubeSides, arg_0), new Property[]{ColoredSapling.LIT, ColoredSapling.COLOR});
    }

    private void grassBlockWithElements(GrassBlock coloredGrassBlock, String defaultTexture, String grassBlockTexture) {
        ResourceLocation grassBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)coloredGrassBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ResourceLocation textureTop = ResourceLocation.parse((String)(grassBlockTexture + "_top"));
        ResourceLocation textureSide = ResourceLocation.parse((String)(grassBlockTexture + "_side"));
        ResourceLocation textureTopSnow = ResourceLocation.parse((String)(grassBlockTexture + "_top_snow"));
        ResourceLocation textureSideSnow = ResourceLocation.parse((String)(grassBlockTexture + "_side_snow"));
        ModelBuilder grass = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(grassBlockRegistryName.getPath(), "colors:block/tintable_cube_bottom_top")).texture("bottom", texture)).texture("top", textureTop)).texture("side", textureSide)).texture("particle", textureSide)).renderType("cutout");
        ModelBuilder grassSnowed = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(grassBlockRegistryName.getPath() + "_snow", "colors:tintable_cube_bottom_top")).texture("bottom", texture)).texture("top", textureTopSnow)).texture("side", textureSideSnow)).texture("particle", textureSideSnow)).renderType("cutout");
        this.simpleBlockItem((Block)coloredGrassBlock, (ModelFile)grass);
        this.getVariantBuilder((Block)coloredGrassBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$grassBlockWithElements$5((ModelFile)grassSnowed, (ModelFile)grass, arg_0), new Property[]{ColoredSapling.LIT});
    }

    private void doorWithElements(DoorBlock doorBlock, String defaultTexture) {
        ResourceLocation doorBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)doorBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ResourceLocation textureTop = ResourceLocation.parse((String)(defaultTexture + "_door_top"));
        ResourceLocation textureBottom = ResourceLocation.parse((String)(defaultTexture + "_door_bottom"));
        ModelBuilder doorTopRightOpen = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_top_right_open", "colors:block/door/tintable_door_top_right_open")).texture("top", textureTop)).renderType("cutout");
        ModelBuilder doorTopLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_top_left_open", "colors:block/door/tintable_door_top_left_open")).texture("top", textureTop)).renderType("cutout");
        ModelBuilder doorTopRight = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_top_right", "colors:block/door/tintable_door_top_right")).texture("top", textureTop)).renderType("cutout");
        ModelBuilder doorTopLeft = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_top_left", "colors:block/door/tintable_door_top_left")).texture("top", textureTop)).renderType("cutout");
        ModelBuilder doorBottomRight = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_bottom_right", "colors:block/door/tintable_door_bottom_right")).texture("bottom", textureBottom)).renderType("cutout");
        ModelBuilder doorBottomLeft = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_bottom_left", "colors:block/door/tintable_door_bottom_left")).texture("bottom", textureBottom)).renderType("cutout");
        ModelBuilder doorBottomRightOpen = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_bottom_right_open", "colors:block/door/tintable_door_bottom_right_open")).texture("bottom", textureBottom)).renderType("cutout");
        ModelBuilder doorBottomLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(doorBlockRegistryName.getPath() + "_bottom_left_open", "colors:block/door/tintable_door_bottom_left_open")).texture("bottom", textureBottom)).renderType("cutout");
        this.getVariantBuilder((Block)doorBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$doorWithElements$6((ModelFile)doorBottomRightOpen, (ModelFile)doorBottomLeftOpen, (ModelFile)doorBottomRight, (ModelFile)doorBottomLeft, (ModelFile)doorTopRightOpen, (ModelFile)doorTopLeftOpen, (ModelFile)doorTopRight, (ModelFile)doorTopLeft, arg_0), new Property[]{DoorBlock.POWERED, ColoredDoor.LIT});
    }

    private void trapDoorWithElements(TrapDoorBlock trapDoorBlock, String defaultTexture, boolean orientable) {
        ResourceLocation trapDoorBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)trapDoorBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder trapDoorTop = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(trapDoorBlockRegistryName.getPath() + "_top", "colors:block/trapdoor/tintable_orientable_trapdoor_top")).texture("texture", texture)).renderType("cutout");
        ModelBuilder trapDoorBottom = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(trapDoorBlockRegistryName.getPath() + "_bottom", "colors:block/trapdoor/tintable_orientable_trapdoor_bottom")).texture("texture", texture)).renderType("cutout");
        ModelBuilder trapDoorOpen = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(trapDoorBlockRegistryName.getPath() + "_open", "colors:block/trapdoor/tintable_orientable_trapdoor_open")).texture("texture", texture)).renderType("cutout");
        this.getVariantBuilder((Block)trapDoorBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$trapDoorWithElements$7(orientable, (ModelFile)trapDoorOpen, (ModelFile)trapDoorTop, (ModelFile)trapDoorBottom, arg_0), new Property[]{TrapDoorBlock.POWERED, TrapDoorBlock.WATERLOGGED, ColoredTrapDoor.LIT});
        this.simpleBlockItem((Block)trapDoorBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + trapDoorBlockRegistryName.getPath() + "_bottom"));
    }

    private void fenceWithElements(FenceBlock fenceBlock, String defaultTexture) {
        ResourceLocation fenceBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)fenceBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder fenceInventory = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fenceBlockRegistryName.getPath() + "_inventory", "colors:block/fence/tintable_fence_inventory")).texture("texture", texture)).renderType("cutout");
        ModelBuilder fencePost = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fenceBlockRegistryName.getPath() + "_post", "colors:block/fence/tintable_fence_post")).texture("texture", texture)).renderType("cutout");
        ModelBuilder fenceSide = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fenceBlockRegistryName.getPath() + "_side", "colors:block/fence/tintable_fence_side")).texture("texture", texture)).renderType("cutout");
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)fenceBlock).part().modelFile((ModelFile)fencePost).addModel()).end();
        this.fourWayMultipart(builder, (ModelFile)fenceSide);
        this.simpleBlockItem((Block)fenceBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + fenceBlockRegistryName.getPath() + "_inventory"));
    }

    private void fenceGateWithElements(FenceGateBlock fenceGateBlock, String defaultTexture) {
        ResourceLocation fenceGateBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)fenceGateBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder fenceGate = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fenceGateBlockRegistryName.getPath(), "colors:block/fence_gate/tintable_fence_gate")).texture("texture", texture)).renderType("cutout");
        ModelBuilder fenceGateOpen = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fenceGateBlockRegistryName.getPath() + "_open", "colors:block/fence_gate/tintable_fence_gate_open")).texture("texture", texture)).renderType("cutout");
        ModelBuilder fenceGateWallOpen = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fenceGateBlockRegistryName.getPath() + "_wall_open", "colors:block/fence_gate/tintable_fence_gate_wall_open")).texture("texture", texture)).renderType("cutout");
        ModelBuilder fenceGateWall = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(fenceGateBlockRegistryName.getPath() + "_wall", "colors:block/fence_gate/tintable_fence_gate_wall")).texture("texture", texture)).renderType("cutout");
        this.getVariantBuilder((Block)fenceGateBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$fenceGateWithElements$8((ModelFile)fenceGate, (ModelFile)fenceGateWall, (ModelFile)fenceGateWallOpen, (ModelFile)fenceGateOpen, arg_0), new Property[]{FenceGateBlock.POWERED, ColoredFence.LIT});
        this.simpleBlockItem((Block)fenceGateBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + fenceGateBlockRegistryName.getPath()));
    }

    private void slabWithElements(SlabBlock slabBlock, String defaultTexture) {
        ResourceLocation slabBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)slabBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder slab = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(slabBlockRegistryName.getPath(), "colors:block/slab/tintable_slab")).texture("bottom", texture)).texture("top", texture)).texture("side", texture)).renderType("cutout");
        ModelBuilder slabTop = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(slabBlockRegistryName.getPath() + "_top", "colors:block/slab/tintable_slab_top")).texture("bottom", texture)).texture("top", texture)).texture("side", texture)).renderType("cutout");
        String path = slabBlockRegistryName.getPath();
        path = slabBlockRegistryName.getPath().contains("brick_slab") ? slabBlockRegistryName.getPath().replace("_slab", "s") : (slabBlockRegistryName.getPath().contains("tile_slab") ? slabBlockRegistryName.getPath().replace("_slab", "s") : (slabBlockRegistryName.getPath().contains("plank_slab") ? slabBlockRegistryName.getPath().replace("_slab", "s") : slabBlockRegistryName.getPath().replace("_slab", "")));
        ModelBuilder doubleSlab = ((BlockModelBuilder)this.models().withExistingParent(path, ResourceLocation.parse((String)"colors:block/tintable_cube_all"))).texture("all", texture);
        this.getVariantBuilder((Block)slabBlock).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slab)}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)slabTop)}).partialState().with((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)doubleSlab)});
        this.simpleBlockItem((Block)slabBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + slabBlockRegistryName.getPath()));
    }

    private void simpleBlockWithElements(Block block, String defaultTexture) {
        ResourceLocation blockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)block);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder cube = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockRegistryName.getPath(), "colors:block/tintable_cube_all")).texture("all", texture)).texture("particle", texture);
        this.simpleBlockItem(block, (ModelFile)cube);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$simpleBlockWithElements$9((ModelFile)cube, arg_0), new Property[]{ColoredBlock.LIT});
    }

    private void buttonWithElements(ButtonBlock buttonBlock, String defaultTexture) {
        ResourceLocation buttonBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)buttonBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder button = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(buttonBlockRegistryName.getPath(), "colors:block/button/tintable_button")).texture("texture", texture)).renderType("cutout");
        ModelBuilder buttonPressed = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(buttonBlockRegistryName.getPath() + "_pressed", "colors:block/button/tintable_button_pressed")).texture("texture", texture)).renderType("cutout");
        ModelBuilder buttonInventory = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(buttonBlockRegistryName.getPath() + "_inventory", "colors:block/button/tintable_button_inventory")).texture("texture", texture)).renderType("cutout");
        this.getVariantBuilder((Block)buttonBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$buttonWithElements$10((ModelFile)buttonPressed, (ModelFile)button, arg_0), new Property[0]);
        this.simpleBlockItem((Block)buttonBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + buttonBlockRegistryName.getPath() + "_inventory"));
    }

    private void pressurePlateWithElements(PressurePlateBlock pressurePlateBlock, String defaultTexture) {
        ResourceLocation pressurePlateBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)pressurePlateBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder pressurePlate = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(pressurePlateBlockRegistryName.getPath(), "colors:block/pressure_plate/tintable_pressure_plate_up")).texture("texture", texture)).renderType("cutout");
        ModelBuilder pressurePlateDown = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(pressurePlateBlockRegistryName.getPath() + "_down", "colors:block/pressure_plate/tintable_pressure_plate_down")).texture("texture", texture)).renderType("cutout");
        this.getVariantBuilder((Block)pressurePlateBlock).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressurePlateDown)}).partialState().with((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)pressurePlate)});
        this.simpleBlockItem((Block)pressurePlateBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + pressurePlateBlockRegistryName.getPath()));
    }

    private void wallWithElements(WallBlock wallBlock, String defaultTexture) {
        ResourceLocation wallBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)wallBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder wallInventory = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(wallBlockRegistryName.getPath() + "_inventory", "colors:block/wall/tintable_wall_inventory")).texture("wall", texture)).renderType("cutout");
        ModelBuilder wallPost = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(wallBlockRegistryName.getPath() + "_post", "colors:block/wall/tintable_wall_post")).texture("wall", texture)).renderType("cutout");
        ModelBuilder wallSide = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(wallBlockRegistryName.getPath() + "_side", "colors:block/wall/tintable_wall_side")).texture("wall", texture)).renderType("cutout");
        ModelBuilder wallSideTall = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(wallBlockRegistryName.getPath() + "_side_tall", "colors:block/wall/tintable_wall_side_tall")).texture("wall", texture)).renderType("cutout");
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)wallBlock).part().modelFile((ModelFile)wallPost).addModel()).condition((Property)WallBlock.UP, (Comparable[])new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).getAxis().isHorizontal()).forEach(arg_0 -> this.lambda$wallWithElements$12(builder, (ModelFile)wallSide, (ModelFile)wallSideTall, arg_0));
        this.simpleBlockItem((Block)wallBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + wallBlockRegistryName.getPath() + "_inventory"));
    }

    private void wallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, Map.Entry<Direction, Property<WallSide>> entry, WallSide height) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model).rotationY(((int)entry.getKey().toYRot() + 180) % 360).uvLock(true).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height});
    }

    private void stairsWithElements(StairBlock stairsBlock, String defaultTexture) {
        ResourceLocation stairBlockRegistryName = BuiltInRegistries.BLOCK.getKey((Object)stairsBlock);
        ResourceLocation texture = ResourceLocation.parse((String)defaultTexture);
        ModelBuilder stairs = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(stairBlockRegistryName.getPath(), "colors:block/stairs/tintable_stairs")).texture("bottom", texture)).texture("top", texture)).texture("side", texture)).renderType("cutout");
        ModelBuilder innerStairs = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(stairBlockRegistryName.getPath() + "_inner", "colors:block/stairs/tintable_inner_stairs")).texture("bottom", texture)).texture("top", texture)).texture("side", texture)).renderType("cutout");
        ModelBuilder outerStairs = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(stairBlockRegistryName.getPath() + "_outer", "colors:block/stairs/tintable_outer_stairs")).texture("bottom", texture)).texture("top", texture)).texture("side", texture)).renderType("cutout");
        this.getVariantBuilder((Block)stairsBlock).forAllStatesExcept(arg_0 -> ColorsBlockStatesProvider.lambda$stairsWithElements$13((ModelFile)stairs, (ModelFile)innerStairs, (ModelFile)outerStairs, arg_0), new Property[]{StairBlock.WATERLOGGED, ColoredStairs.LIT});
        this.simpleBlockItem((Block)stairsBlock, (ModelFile)new ModelFile.UncheckedModelFile("colors:block/" + stairBlockRegistryName.getPath()));
    }

    public String getName() {
        return "colors Block States";
    }

    private static /* synthetic */ ConfiguredModel[] lambda$stairsWithElements$13(ModelFile stairs, ModelFile innerStairs, ModelFile outerStairs, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        Half half = (Half)state.getValue((Property)StairBlock.HALF);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        int yRot = (int)facing.getClockWise().toYRot();
        if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
            yRot += 270;
        }
        if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
            yRot += 90;
        }
        boolean uvlock = (yRot %= 360) != 0 || half == Half.TOP;
        return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? innerStairs : outerStairs)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
    }

    private /* synthetic */ void lambda$wallWithElements$12(MultiPartBlockStateBuilder builder, ModelFile wallSide, ModelFile wallSideTall, Map.Entry e) {
        this.wallSidePart(builder, wallSide, e, WallSide.LOW);
        this.wallSidePart(builder, wallSideTall, e, WallSide.TALL);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buttonWithElements$10(ModelFile buttonPressed, ModelFile button, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)ButtonBlock.FACING);
        AttachFace face = (AttachFace)state.getValue((Property)ButtonBlock.FACE);
        boolean powered = (Boolean)state.getValue((Property)ButtonBlock.POWERED);
        return ConfiguredModel.builder().modelFile(powered ? buttonPressed : button).rotationX(face == AttachFace.FLOOR ? 0 : (face == AttachFace.WALL ? 90 : 180)).rotationY((int)(face == AttachFace.CEILING ? facing : facing.getOpposite()).toYRot()).uvLock(face == AttachFace.WALL).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$simpleBlockWithElements$9(ModelFile cube, BlockState state) {
        return ConfiguredModel.builder().modelFile(cube).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$fenceGateWithElements$8(ModelFile fenceGate, ModelFile fenceGateWall, ModelFile fenceGateWallOpen, ModelFile fenceGateOpen, BlockState state) {
        ModelFile model = fenceGate;
        if (((Boolean)state.getValue((Property)FenceGateBlock.IN_WALL)).booleanValue()) {
            model = fenceGateWall;
        }
        if (((Boolean)state.getValue((Property)FenceGateBlock.OPEN)).booleanValue()) {
            model = model == fenceGateWall ? fenceGateWallOpen : fenceGateOpen;
        }
        return ConfiguredModel.builder().modelFile(model).rotationY((int)((Direction)state.getValue((Property)FenceGateBlock.FACING)).toYRot()).uvLock(true).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$trapDoorWithElements$7(boolean orientable, ModelFile trapDoorOpen, ModelFile trapDoorTop, ModelFile trapDoorBottom, BlockState state) {
        int xRot = 0;
        int yRot = (int)((Direction)state.getValue((Property)TrapDoorBlock.FACING)).toYRot() + 180;
        boolean isOpen = (Boolean)state.getValue((Property)TrapDoorBlock.OPEN);
        if (orientable && isOpen && state.getValue((Property)TrapDoorBlock.HALF) == Half.TOP) {
            xRot += 180;
            yRot += 180;
        }
        if (!orientable && !isOpen) {
            yRot = 0;
        }
        return ConfiguredModel.builder().modelFile(isOpen ? trapDoorOpen : (state.getValue((Property)TrapDoorBlock.HALF) == Half.TOP ? trapDoorTop : trapDoorBottom)).rotationX(xRot).rotationY(yRot %= 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$doorWithElements$6(ModelFile doorBottomRightOpen, ModelFile doorBottomLeftOpen, ModelFile doorBottomRight, ModelFile doorBottomLeft, ModelFile doorTopRightOpen, ModelFile doorTopLeftOpen, ModelFile doorTopRight, ModelFile doorTopLeft, BlockState state) {
        boolean lower;
        int yRot = (int)((Direction)state.getValue((Property)DoorBlock.FACING)).toYRot() + 90;
        boolean right = state.getValue((Property)DoorBlock.HINGE) == DoorHingeSide.RIGHT;
        boolean open = (Boolean)state.getValue((Property)DoorBlock.OPEN);
        boolean bl = lower = state.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.LOWER;
        if (open) {
            yRot += 90;
        }
        if (right && open) {
            yRot += 180;
        }
        yRot %= 360;
        ModelFile model = null;
        if (lower && right && open) {
            model = doorBottomRightOpen;
        } else if (lower && !right && open) {
            model = doorBottomLeftOpen;
        }
        if (lower && right && !open) {
            model = doorBottomRight;
        } else if (lower && !right && !open) {
            model = doorBottomLeft;
        }
        if (!lower && right && open) {
            model = doorTopRightOpen;
        } else if (!lower && !right && open) {
            model = doorTopLeftOpen;
        }
        if (!lower && right && !open) {
            model = doorTopRight;
        } else if (!(lower || right || open)) {
            model = doorTopLeft;
        }
        return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$grassBlockWithElements$5(ModelFile grassSnowed, ModelFile grass, BlockState state) {
        boolean snowy = (Boolean)state.getValue((Property)SnowyDirtBlock.SNOWY);
        return ConfiguredModel.allYRotations((ModelFile)(snowy ? grassSnowed : grass), (int)0, (boolean)false);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$craftingTableBlock$4(ModelFile cubeSides, BlockState state) {
        return ConfiguredModel.builder().modelFile(cubeSides).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$flowerWithElements$3(ModelFile sapling, BlockState state) {
        return ConfiguredModel.builder().modelFile(sapling).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$saplingWithElements$2(ModelFile sapling, BlockState state) {
        return ConfiguredModel.builder().modelFile(sapling).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$doublePlantWithElements$1(ModelFile doubleTop, ModelFile doubleBottom, BlockState state) {
        boolean top = ((DoubleBlockHalf)state.getValue((Property)DoublePlantBlock.HALF)).equals((Object)DoubleBlockHalf.UPPER);
        boolean lower = ((DoubleBlockHalf)state.getValue((Property)DoublePlantBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER);
        return ConfiguredModel.builder().modelFile(top ? doubleTop : doubleBottom).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$tallGrassWithElements$0(ModelFile sapling, BlockState state) {
        return ConfiguredModel.builder().modelFile(sapling).build();
    }
}

