/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.block;

import com.benbenlaw.colors.block.sets.PlankLikeBlocksList;
import com.benbenlaw.colors.block.sets.StoneLikeBlocksList;
import com.benbenlaw.colors.item.ColorsItems;
import com.benbenlaw.colors.worldgen.ColorsConfiguredFeatures;
import com.benbenlaw.colors.worldgen.tree.ColorsTreeGrowers;
import com.benbenlaw.core.block.brightable.BrightBlock;
import com.benbenlaw.core.block.brightable.BrightButton;
import com.benbenlaw.core.block.brightable.BrightCraftingTable;
import com.benbenlaw.core.block.brightable.BrightDoor;
import com.benbenlaw.core.block.brightable.BrightDoublePlantBlock;
import com.benbenlaw.core.block.brightable.BrightFlower;
import com.benbenlaw.core.block.brightable.BrightFlowerPot;
import com.benbenlaw.core.block.brightable.BrightGrassBlock;
import com.benbenlaw.core.block.brightable.BrightPressurePlate;
import com.benbenlaw.core.block.brightable.BrightSapling;
import com.benbenlaw.core.block.brightable.BrightSlab;
import com.benbenlaw.core.block.brightable.BrightStairs;
import com.benbenlaw.core.block.brightable.BrightTallGrassBlock;
import com.benbenlaw.core.block.brightable.BrightTrapDoor;
import com.benbenlaw.core.block.brightable.BrightWall;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableFence;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableFenceGate;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableLeaves;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableLog;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableSlab;
import com.benbenlaw.core.block.brightable.flammable.BrightFlammableStairs;
import com.benbenlaw.core.util.ColorList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ColorsBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"colors");
    public static final Map<String, DeferredBlock<Block>> STONE_BLOCKS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> PLANKS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> DIRT = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> GRASS_BLOCK = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> CRAFTING_TABLE = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> TALL_GRASS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> SHORT_GRASS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> DANDELION = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> POTTED_DANDELION = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> POPPY = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> POTTED_POPPY = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> LEAVES = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> LOGS = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> WOOD = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> BAMBOO = new HashMap<String, DeferredBlock<Block>>();
    public static final Map<String, DeferredBlock<Block>> SAPLINGS = new HashMap<String, DeferredBlock<Block>>();

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ColorsBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ColorsItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static ToIntFunction<BlockState> litBlockEmission() {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0;
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    static {
        for (String color : ColorList.COLORS) {
            String keyPrefix;
            String singularType;
            SAPLINGS.put(color + "_sapling", ColorsBlocks.registerBlock(color + "_sapling", () -> new BrightSapling(ColorsTreeGrowers.TREE_GROWERS.get(color), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING).lightLevel(ColorsBlocks.litBlockEmission()))));
            BAMBOO.put(color + "_bamboo", ColorsBlocks.registerBlock(color + "_bamboo", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_BLOCK).lightLevel(ColorsBlocks.litBlockEmission()))));
            BAMBOO.put(color + "_stripped_bamboo", ColorsBlocks.registerBlock(color + "_stripped_bamboo", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_BLOCK).lightLevel(ColorsBlocks.litBlockEmission()))));
            LOGS.put(color + "_log", ColorsBlocks.registerBlock(color + "_log", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG).lightLevel(ColorsBlocks.litBlockEmission()))));
            LOGS.put(color + "_stripped_log", ColorsBlocks.registerBlock(color + "_stripped_log", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG).lightLevel(ColorsBlocks.litBlockEmission()))));
            WOOD.put(color + "_wood", ColorsBlocks.registerBlock(color + "_wood", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD).lightLevel(ColorsBlocks.litBlockEmission()))));
            WOOD.put(color + "_stripped_wood", ColorsBlocks.registerBlock(color + "_stripped_wood", () -> new BrightFlammableLog(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD).lightLevel(ColorsBlocks.litBlockEmission()))));
            LEAVES.put(color + "_leaves", ColorsBlocks.registerBlock(color + "_leaves", () -> new BrightFlammableLeaves(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).lightLevel(ColorsBlocks.litBlockEmission()))));
            TALL_GRASS.put(color + "_tall_grass", ColorsBlocks.registerBlock(color + "_tall_grass", () -> new BrightDoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).lightLevel(ColorsBlocks.litBlockEmission()))));
            SHORT_GRASS.put(color + "_short_grass", ColorsBlocks.registerBlock(color + "_short_grass", () -> new BrightTallGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).lightLevel(ColorsBlocks.litBlockEmission()), (BrightDoublePlantBlock)TALL_GRASS.get(color + "_tall_grass").get())));
            DANDELION.put(color + "_dandelion", ColorsBlocks.registerBlock(color + "_dandelion", () -> new BrightFlower(MobEffects.ABSORPTION, 0.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY).sound(SoundType.GRASS).lightLevel(ColorsBlocks.litBlockEmission()).noOcclusion())));
            POTTED_DANDELION.put(color + "_potted_dandelion", ColorsBlocks.registerBlockWithoutBlockItem(color + "_potted_dandelion", () -> new BrightFlowerPot(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier)DANDELION.get(color + "_dandelion"), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_DANDELION).lightLevel(ColorsBlocks.litBlockEmission()))));
            POPPY.put(color + "_poppy", ColorsBlocks.registerBlock(color + "_poppy", () -> new BrightFlower(MobEffects.ABSORPTION, 0.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY).sound(SoundType.GRASS).lightLevel(ColorsBlocks.litBlockEmission()).noOcclusion())));
            POTTED_POPPY.put(color + "_potted_poppy", ColorsBlocks.registerBlockWithoutBlockItem(color + "_potted_poppy", () -> new BrightFlowerPot(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier)POPPY.get(color + "_poppy"), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_POPPY).lightLevel(ColorsBlocks.litBlockEmission()))));
            DIRT.put(color + "_dirt", ColorsBlocks.registerBlock(color + "_dirt", () -> new BrightBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).lightLevel(ColorsBlocks.litBlockEmission()))));
            GRASS_BLOCK.put(color + "_grass_block", ColorsBlocks.registerBlock(color + "_grass_block", () -> new BrightGrassBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).lightLevel(ColorsBlocks.litBlockEmission()), ColorsConfiguredFeatures.GRASS_BONEMEAL_KEY.get(color), (Block)DIRT.get(color + "_dirt").get(), (Block)SHORT_GRASS.get(color + "_short_grass").get())));
            CRAFTING_TABLE.put(color + "_crafting_table", ColorsBlocks.registerBlock(color + "_crafting_table", () -> new BrightCraftingTable(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE).lightLevel(ColorsBlocks.litBlockEmission()))));
            for (String type : PlankLikeBlocksList.PLANKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                PLANKS.put(color + "_" + type, ColorsBlocks.registerBlock(color + "_" + type, () -> new BrightBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).lightLevel(ColorsBlocks.litBlockEmission()))));
                PLANKS.put(keyPrefix + "_stairs", ColorsBlocks.registerBlock(keyPrefix + "_stairs", () -> {
                    BlockState baseState = ((Block)PLANKS.get(color + "_" + type).get()).defaultBlockState();
                    return new BrightFlammableStairs(baseState, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).lightLevel(ColorsBlocks.litBlockEmission()));
                }));
                PLANKS.put(keyPrefix + "_slab", ColorsBlocks.registerBlock(keyPrefix + "_slab", () -> new BrightFlammableSlab(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).lightLevel(ColorsBlocks.litBlockEmission()))));
                PLANKS.put(keyPrefix + "_fence", ColorsBlocks.registerBlock(keyPrefix + "_fence", () -> new BrightFlammableFence(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).lightLevel(ColorsBlocks.litBlockEmission()))));
                PLANKS.put(keyPrefix + "_fence_gate", ColorsBlocks.registerBlock(keyPrefix + "_fence_gate", () -> new BrightFlammableFenceGate(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).lightLevel(ColorsBlocks.litBlockEmission()), SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE)));
                PLANKS.put(keyPrefix + "_pressure_plate", ColorsBlocks.registerBlock(keyPrefix + "_pressure_plate", () -> new BrightPressurePlate(BlockSetType.PressurePlateSensitivity.EVERYTHING, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).lightLevel(ColorsBlocks.litBlockEmission()), BlockSetType.OAK)));
                PLANKS.put(keyPrefix + "_button", ColorsBlocks.registerBlock(keyPrefix + "_button", () -> new BrightButton(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON).lightLevel(ColorsBlocks.litBlockEmission()), BlockSetType.OAK, 30, true)));
                PLANKS.put(keyPrefix + "_trapdoor", ColorsBlocks.registerBlock(keyPrefix + "_trapdoor", () -> new BrightTrapDoor(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).lightLevel(ColorsBlocks.litBlockEmission()), BlockSetType.OAK)));
                PLANKS.put(keyPrefix + "_door", ColorsBlocks.registerBlock(keyPrefix + "_door", () -> new BrightDoor(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).lightLevel(ColorsBlocks.litBlockEmission()), BlockSetType.OAK)));
            }
            for (String type : StoneLikeBlocksList.STONE_BLOCKS) {
                singularType = type.endsWith("s") ? type.substring(0, type.length() - 1) : type;
                keyPrefix = color + "_" + singularType;
                STONE_BLOCKS.put(color + "_" + type, ColorsBlocks.registerBlock(color + "_" + type, () -> new BrightBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(ColorsBlocks.litBlockEmission()))));
                STONE_BLOCKS.put(keyPrefix + "_stairs", ColorsBlocks.registerBlock(keyPrefix + "_stairs", () -> {
                    BlockState baseState = ((Block)STONE_BLOCKS.get(color + "_" + type).get()).defaultBlockState();
                    return new BrightStairs(baseState, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).lightLevel(ColorsBlocks.litBlockEmission()));
                }));
                STONE_BLOCKS.put(keyPrefix + "_slab", ColorsBlocks.registerBlock(keyPrefix + "_slab", () -> new BrightSlab(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).lightLevel(ColorsBlocks.litBlockEmission()))));
                STONE_BLOCKS.put(keyPrefix + "_wall", ColorsBlocks.registerBlock(keyPrefix + "_wall", () -> new BrightWall(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL).lightLevel(ColorsBlocks.litBlockEmission()))));
                STONE_BLOCKS.put(keyPrefix + "_pressure_plate", ColorsBlocks.registerBlock(keyPrefix + "_pressure_plate", () -> new BrightPressurePlate(BlockSetType.PressurePlateSensitivity.MOBS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_PRESSURE_PLATE).lightLevel(ColorsBlocks.litBlockEmission()), BlockSetType.STONE)));
                STONE_BLOCKS.put(keyPrefix + "_button", ColorsBlocks.registerBlock(keyPrefix + "_button", () -> new BrightButton(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BUTTON).lightLevel(ColorsBlocks.litBlockEmission()), BlockSetType.STONE, 20, false)));
            }
        }
    }
}

