/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors;

import com.benbenlaw.colors.block.ColorsBlocks;
import com.benbenlaw.colors.config.StartupConfig;
import com.benbenlaw.colors.config.WorldGenConfig;
import com.benbenlaw.colors.item.ColorsCreativeTab;
import com.benbenlaw.colors.item.ColorsItems;
import com.benbenlaw.colors.maps.StrippedLogMap;
import com.benbenlaw.colors.util.ColorHandler;
import com.benbenlaw.colors.worldgen.ColorsWorldGen;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="colors")
public class Colors {
    public static final String MOD_ID = "colors";
    private static final Logger LOGGER = LogManager.getLogger();

    public Colors(IEventBus modEventBus, ModContainer modContainer) {
        ColorsBlocks.BLOCKS.register(modEventBus);
        ColorsItems.ITEMS.register(modEventBus);
        ColorsCreativeTab.CREATIVE_TABS.register(modEventBus);
        ColorsWorldGen.PLACEMENTS.register(modEventBus);
        ColorsWorldGen.FEATURES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)WorldGenConfig.SPEC, "bbl/colors/worldgen.toml");
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StartupConfig.SPEC, "bbl/colors/startup.toml");
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::commonSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.register((Object)new ColorHandler());
        }
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        StrippedLogMap logMap = new StrippedLogMap();
        logMap.updateLogMaps();
        event.enqueueWork(() -> {
            DeferredBlock<Block> block;
            String poppyBlock;
            for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.POPPY.entrySet()) {
                poppyBlock = entry.getKey().replace("_poppy", "_potted_poppy");
                block = ColorsBlocks.POTTED_POPPY.get(poppyBlock);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(entry.getValue().getId(), block);
            }
            for (Map.Entry<String, DeferredBlock<Block>> entry : ColorsBlocks.DANDELION.entrySet()) {
                poppyBlock = entry.getKey().replace("_dandelion", "_potted_dandelion");
                block = ColorsBlocks.POTTED_DANDELION.get(poppyBlock);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(entry.getValue().getId(), block);
            }
        });
    }

    @EventBusSubscriber(modid="colors", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
        }
    }
}

