/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.woodenhopper.platform;

import de.cech12.woodenhopper.Constants;
import de.cech12.woodenhopper.block.WoodenHopperBlock;
import de.cech12.woodenhopper.blockentity.NeoForgeWoodenHopperBlockEntity;
import de.cech12.woodenhopper.blockentity.WoodenHopperBlockEntity;
import de.cech12.woodenhopper.inventory.WoodenHopperContainer;
import de.cech12.woodenhopper.platform.services.IRegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class NeoForgeRegistryHelper
implements IRegistryHelper {
    public static final DeferredRegister.Blocks BLOCKS;
    public static final DeferredRegister.Items ITEMS;
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES;
    public static final DeferredRegister<MenuType<?>> MENU_TYPES;

    private static DeferredItem<Item> fromBlock(DeferredBlock<Block> block) {
        return ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    @Override
    public WoodenHopperBlockEntity getNewBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new NeoForgeWoodenHopperBlockEntity(pos, state);
    }

    static {
        DeferredBlock block;
        BLOCKS = DeferredRegister.createBlocks((String)"woodenhopper");
        ITEMS = DeferredRegister.createItems((String)"woodenhopper");
        BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"woodenhopper");
        MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"woodenhopper");
        Constants.WOODEN_HOPPER_BLOCK = block = BLOCKS.register("wooden_hopper", () -> new WoodenHopperBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.5f).sound(SoundType.WOOD).noOcclusion()));
        Constants.WOODEN_HOPPER_ITEM = NeoForgeRegistryHelper.fromBlock((DeferredBlock<Block>)block);
        Constants.WOODEN_HOPPER_BLOCK_ENTITY_TYPE = BLOCK_ENTITY_TYPES.register("wooden_hopper", () -> BlockEntityType.Builder.of(NeoForgeWoodenHopperBlockEntity::new, (Block[])new Block[]{Constants.WOODEN_HOPPER_BLOCK.get()}).build(null));
        Constants.WOODEN_HOPPER_MENU_TYPE = MENU_TYPES.register("woodenhopper", () -> IMenuTypeExtension.create((pWindowID, pInventory, pData) -> new WoodenHopperContainer(pWindowID, pInventory)));
    }
}

