/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.multiblock;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public final class MultiblockData
implements INBTSerializable {
    private BlockPos controllerPos;
    private Pair<BlockPos, BlockPos> topCorners;
    private List<BlockPos> multiblockExtraBlocks;
    private int height;
    private int volume;
    private final Set<BlockPos> allBlockPositions;

    public MultiblockData(BlockPos controllerPos, Pair<BlockPos, BlockPos> topCorners, List<BlockPos> extraBlocks, Set<BlockPos> allBlockPositions, int height, int volume) {
        this.controllerPos = controllerPos;
        this.topCorners = topCorners;
        this.multiblockExtraBlocks = extraBlocks;
        this.allBlockPositions = allBlockPositions;
        this.height = height;
        this.volume = volume;
    }

    public Tag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("height", this.height());
        tag.putInt("volume", this.volume());
        tag.putLong("controller", this.controllerPos().asLong());
        tag.putLong("corner1", ((BlockPos)this.topCorners().getFirst()).asLong());
        tag.putLong("corner2", ((BlockPos)this.topCorners().getSecond()).asLong());
        tag.putInt("extraBlocksCount", this.extraBlocks().size());
        int i = 0;
        for (BlockPos blockPos : this.extraBlocks()) {
            tag.putLong("e" + i, blockPos.asLong());
            ++i;
        }
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.height = compoundTag.getInt("height");
            this.volume = compoundTag.getInt("volume");
            this.controllerPos = BlockPos.of((long)compoundTag.getLong("controller"));
            this.topCorners = Pair.of((Object)BlockPos.of((long)compoundTag.getLong("corner1")), (Object)BlockPos.of((long)compoundTag.getLong("corner2")));
            ArrayList<BlockPos> ps = new ArrayList<BlockPos>();
            for (int i = 0; i < compoundTag.getInt("extraBlocksCount"); ++i) {
                ps.add(BlockPos.of((long)compoundTag.getLong("e" + i)));
            }
            this.multiblockExtraBlocks = ps;
        }
    }

    public BlockPos controllerPos() {
        return this.controllerPos;
    }

    public Pair<BlockPos, BlockPos> topCorners() {
        return this.topCorners;
    }

    public List<BlockPos> extraBlocks() {
        return this.multiblockExtraBlocks;
    }

    public Set<BlockPos> allBlockPositions() {
        return this.allBlockPositions;
    }

    public int height() {
        return this.height;
    }

    public int volume() {
        return this.volume;
    }
}

