/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.integration.jei;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.config.CastingConfig;
import com.benbenlaw.casting.integration.jei.JEICastingPlugin;
import com.benbenlaw.casting.recipe.MeltingRecipe;
import com.benbenlaw.casting.util.CastingTags;
import java.awt.Color;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeltingRecipeCategory
implements IRecipeCategory<MeltingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"melting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/jei_melting.png");
    public static final RecipeType<MeltingRecipe> RECIPE_TYPE = RecipeType.create((String)"casting", (String)"melting", MeltingRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    @Nullable
    public ResourceLocation getRegistryName(MeltingRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)MeltingRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((MeltingRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public MeltingRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 120, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CastingBlocks.MULTIBLOCK_CONTROLLER.get()));
    }

    @NotNull
    public RecipeType<MeltingRecipe> getRecipeType() {
        return JEICastingPlugin.MELTING_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"gui.casting.jei.melting");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MeltingRecipe recipe, IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        int amount = recipe.output().getAmount();
        if (recipe.input().ingredient().getItems()[0].is(CastingTags.Items.MELTING_OUTPUT_AMOUNT_EFFECTED)) {
            int finalAmount1 = amount = (int)((double)recipe.output().getAmount() * (Double)CastingConfig.oreMultiplier.get());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 2).addFluidStack(recipe.output().getFluid(), 1000L).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.casting.jei.multiblock_controller_output", (Object[])new Object[]{finalAmount1}).withStyle(ChatFormatting.GOLD))).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.casting.jei.simple_controller_output", (Object[])new Object[]{recipe.output().getAmount()}).withStyle(ChatFormatting.GOLD))).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.casting.jei.melting_temp", (Object[])new Object[]{recipe.meltingTemp()}).withStyle(ChatFormatting.GOLD)));
        } else {
            int finalAmount2 = amount;
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 2).addFluidStack(recipe.output().getFluid(), 1000L).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.literal((String)(finalAmount2 + "mB")).withStyle(ChatFormatting.GOLD))).addRichTooltipCallback((slot, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"gui.casting.jei.melting_temp", (Object[])new Object[]{recipe.meltingTemp()}).withStyle(ChatFormatting.GOLD)));
        }
    }

    public void draw(MeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        int temp = recipe.meltingTemp();
        guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)String.valueOf(temp)), 80, 11, Color.GRAY.getRGB(), false);
        int amount = recipe.output().getAmount();
        if (recipe.input().ingredient().getItems()[0].isDamageableItem()) {
            guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)("1-" + amount)).append("mb"), 80, 1, Color.GRAY.getRGB(), false);
        } else if (recipe.input().ingredient().getItems()[0].is(CastingTags.Items.MELTING_OUTPUT_AMOUNT_EFFECTED)) {
            guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)("*" + amount)).append("mb"), 80, 1, Color.GRAY.getRGB(), false);
        } else {
            guiGraphics.drawString(minecraft.font.self(), (Component)Component.literal((String)String.valueOf(amount)).append("mb"), 80, 1, Color.GRAY.getRGB(), false);
        }
    }
}

